package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_9326;
import net.minecraft.client.render.*;
import java.util.List;

public class SpoutRenderer extends class_11239<SpoutRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public SpoutRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    public void render(SpoutRenderState item, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 26 * windowScaleFactor;
        int height = 65 * windowScaleFactor;
        GpuTexture texture = TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), texture);
        }
        RenderSystem.setProjectionMatrix(field_60042.method_71092(width, height), class_10366.field_54954);
        texture.prepare();
        matrices.method_22903();
        matrices.method_46416(width / 2.0F, height / 2.0F, 0.0F);
        float scale = 20 * windowScaleFactor;
        matrices.method_22905(scale, scale, scale);

        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.getBuffer(class_4722.method_24074());
        float time = AnimationTickHolder.getRenderTime();

        blockState = AllBlocks.SPOUT.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        float cycle = (time - item.offset() * 8) % 30;
        float squeeze = cycle < 20 ? -class_3532.method_15374((float) (cycle / 20f * Math.PI)) : 0;
        float move = -3 * squeeze / 32f;

        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.SPOUT_TOP.get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22903();
        parts = List.of(AllPartialModels.SPOUT_MIDDLE.get());
        matrices.method_46416(0, move, 0);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        parts = List.of(AllPartialModels.SPOUT_BOTTOM.get());
        matrices.method_46416(0, move, 0);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_22903();
        blockState = AllBlocks.DEPOT.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        matrices.method_46416(0.07f, -2, -0.14f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();
        matrices.method_22909();

        class_3611 fluid = item.fluid();
        if (fluid != class_3612.field_15906) {
            class_9326 components = item.components();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
            float fluidScale = 16 * windowScaleFactor;
            matrices.method_22905(fluidScale, -fluidScale, fluidScale);
            matrices.method_46416(0, -1.4f, 0);
            float from = 3f / 16f;
            float to = 17f / 16f;
            FluidRenderHelper.renderFluidBox(
                fluid,
                components,
                from,
                from,
                from,
                to,
                to,
                to,
                field_59933,
                matrices,
                class_765.field_32767,
                false,
                true
            );
            matrices.method_22909();

            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
            matrices.method_46416(scale / 2f, scale * 1.5f, scale / 2f);
            matrices.method_22905(fluidScale, -fluidScale, fluidScale);
            matrices.method_46416(-0.5f, -1f, -0.5f);
            float fluidWidth = 1 / 128f * -squeeze * 16;
            from = -fluidWidth / 2 + 0.5f;
            to = fluidWidth / 2 + 0.5f;
            FluidRenderHelper.renderFluidBox(
                fluid,
                components,
                from,
                0,
                from,
                to,
                2,
                to,
                field_59933,
                matrices,
                class_765.field_32767,
                false,
                true
            );
            matrices.method_22909();
        }

        field_59933.method_22993();
        texture.clear();
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            item.method_72127(),
            item.comp_4122(),
            item.comp_4123(),
            item.comp_4124(),
            item.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
    }

    @Override
    protected void render(SpoutRenderState state, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Spout";
    }

    @Override
    public Class<SpoutRenderState> method_70903() {
        return SpoutRenderState.class;
    }
}
