package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class BlockEntityRenderHelper {

    public static void renderBlockEntities(class_1937 world, Iterable<class_2586> customRenderBEs, class_4587 ms, class_4597 buffer) {
        renderBlockEntities(world, null, customRenderBEs, ms, null, buffer);
    }

    public static void renderBlockEntities(
        class_1937 world,
        Iterable<class_2586> customRenderBEs,
        class_4587 ms,
        class_4597 buffer,
        float pt
    ) {
        renderBlockEntities(world, null, customRenderBEs, ms, null, buffer, pt);
    }

    public static void renderBlockEntities(
        class_1937 world,
        @Nullable VirtualRenderWorld renderWorld,
        Iterable<class_2586> customRenderBEs,
        class_4587 ms,
        @Nullable Matrix4f lightTransform,
        class_4597 buffer
    ) {
        renderBlockEntities(world, renderWorld, customRenderBEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderBlockEntities(
        class_1937 realLevel,
        @Nullable VirtualRenderWorld renderLevel,
        Iterable<class_2586> customRenderBEs,
        class_4587 ms,
        @Nullable Matrix4f lightTransform,
        class_4597 buffer,
        float pt
    ) {
        // First, make sure all BEs have the render level.
        // Need to do this outside of the main loop in case BEs query the level from other virtual BEs.
        // e.g. double chests specifically fetch light from both their own and their neighbor's level,
        // which is honestly kind of silly, but easy to work around here.
        if (renderLevel != null) {
            for (var be : customRenderBEs) {
                be.method_31662(renderLevel);
            }
        }

        Set<class_2586> toRemove = new HashSet<>();

        // Main loop, time to render.
        class_310 mc = class_310.method_1551();
        class_824 dispatcher = mc.method_31975();
        class_243 camera = mc.field_1773.method_19418().method_19326();
        for (class_2586 blockEntity : customRenderBEs) {
            if (VisualizationManager.supportsVisualization(realLevel) && VisualizationHelper.skipVanillaRender(blockEntity))
                continue;

            class_827<class_2586> renderer = dispatcher.method_3550(blockEntity);
            if (renderer == null) {
                // Don't bother looping over it again if we can't do anything with it.
                toRemove.add(blockEntity);
                continue;
            }

            if (renderLevel == null && !renderer.method_33892(blockEntity, realLevel instanceof SchematicLevel ? class_243.field_1353 : camera))
                continue;

            class_2338 pos = blockEntity.method_11016();
            ms.method_22903();
            TransformStack.of(ms).translate(pos);

            try {
                int realLevelLight = class_761.method_23794(realLevel, getLightPos(lightTransform, pos));

                int light;
                if (renderLevel != null) {
                    renderLevel.setExternalLight(realLevelLight);
                    light = class_761.method_23794(renderLevel, pos);
                } else {
                    light = realLevelLight;
                }

                renderer.method_3569(blockEntity, pt, ms, buffer, light, class_4608.field_21444, camera);

            } catch (Exception e) {
                // Prevent this BE from causing more issues in the future.
                toRemove.add(blockEntity);

                String message = "BlockEntity " + RegisteredObjectsHelper.getKeyOrThrow(blockEntity.method_11017()) + " could not be rendered virtually.";
                if (AllConfigs.client().explainRenderErrors.get())
                    Create.LOGGER.error(message, e);
                else
                    Create.LOGGER.error(message);
            }

            ms.method_22909();
        }

        // Now reset all the BEs' levels.
        if (renderLevel != null) {
            renderLevel.resetExternalLight();

            for (var be : customRenderBEs) {
                be.method_31662(realLevel);
            }
        }

        // And finally, cull any BEs that misbehaved.
        if (!toRemove.isEmpty()) {
            var it = customRenderBEs.iterator();
            while (it.hasNext()) {
                if (toRemove.contains(it.next())) {
                    it.remove();
                }
            }
        }
    }

    private static class_2338 getLightPos(@Nullable Matrix4f lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f(contraptionPos.method_10263() + .5f, contraptionPos.method_10264() + .5f, contraptionPos.method_10260() + .5f, 1);
            lightVec.mul(lightTransform);
            return class_2338.method_49637(lightVec.x(), lightVec.y(), lightVec.z());
        } else {
            return contraptionPos;
        }
    }

}
