package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1306;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_591;
import net.minecraft.class_630;

public class PlayerSkyhookRenderer {

    private static final Set<UUID> hangingPlayers = new HashSet<>();

    public static void updatePlayerList(Collection<UUID> uuids) {
        hangingPlayers.clear();
        hangingPlayers.addAll(uuids);
    }

    public static void afterSetupAnim(UUID uuid, class_1306 mainArm, class_591 model) {
        if (hangingPlayers.contains(uuid))
            setHangingPose(mainArm == class_1306.field_6182, model);
    }

    private static void setHangingPose(boolean isLeftArmMain, class_591 model) {
        if (class_310.method_1551().method_1493())
            return;

        model.field_3398.field_3657 = 0;
        model.field_3394.field_3657 = 0;
        model.field_3391.method_41923();
        model.field_27433.method_41923();
        model.field_3401.method_41923();
        model.field_3397.method_41923();
        model.field_3392.method_41923();

        float time = AnimationTickHolder.getTicks(true) + AnimationTickHolder.getPartialTicks();
        float mainCycle = class_3532.method_15374(((float) ((time + 10) * 0.3f / Math.PI)));
        float limbCycle = class_3532.method_15374(((float) (time * 0.3f / Math.PI)));
        float bodySwing = AngleHelper.rad(15 + (mainCycle * 10));
        float limbSwing = AngleHelper.rad(limbCycle * 15);
        if (isLeftArmMain)
            bodySwing = -bodySwing;
        model.field_3391.field_3674 = bodySwing;
        model.field_3398.field_3674 = bodySwing;
        model.field_3394.field_3674 = bodySwing;

        class_630 hangingArm = isLeftArmMain ? model.field_27433 : model.field_3401;
        class_630 otherArm = isLeftArmMain ? model.field_3401 : model.field_27433;
        hangingArm.field_3656 -= 3;

        float offsetX = hangingArm.field_3657;
        float offsetY = hangingArm.field_3656;
        //		model.rightArm.x = offsetX * Mth.cos(bodySwing) - offsetY * Mth.sin(bodySwing);
        //		model.rightArm.y = offsetX * Mth.sin(bodySwing) + offsetY * Mth.cos(bodySwing);
        float armPivotX = offsetX * class_3532.method_15362(bodySwing) - offsetY * class_3532.method_15374(bodySwing) + (isLeftArmMain ? -1 : 1) * 4.5f;
        float armPivotY = offsetX * class_3532.method_15374(bodySwing) + offsetY * class_3532.method_15362(bodySwing) + 2;
        hangingArm.field_3654 = -AngleHelper.rad(150);
        hangingArm.field_3674 = (isLeftArmMain ? -1 : 1) * AngleHelper.rad(15);

        offsetX = otherArm.field_3657;
        offsetY = otherArm.field_3656;
        otherArm.field_3657 = offsetX * class_3532.method_15362(bodySwing) - offsetY * class_3532.method_15374(bodySwing);
        otherArm.field_3656 = offsetX * class_3532.method_15374(bodySwing) + offsetY * class_3532.method_15362(bodySwing);
        otherArm.field_3674 = (isLeftArmMain ? -1 : 1) * (-AngleHelper.rad(20)) + 0.5f * bodySwing + limbSwing;

        class_630 leadingLeg = isLeftArmMain ? model.field_3397 : model.field_3392;
        class_630 trailingLeg = isLeftArmMain ? model.field_3392 : model.field_3397;

        leadingLeg.field_3656 -= 0.2f;
        offsetX = leadingLeg.field_3657;
        offsetY = leadingLeg.field_3656;
        leadingLeg.field_3657 = offsetX * class_3532.method_15362(bodySwing) - offsetY * class_3532.method_15374(bodySwing);
        leadingLeg.field_3656 = offsetX * class_3532.method_15374(bodySwing) + offsetY * class_3532.method_15362(bodySwing);
        leadingLeg.field_3654 = -AngleHelper.rad(25);
        leadingLeg.field_3674 = (isLeftArmMain ? -1 : 1) * (AngleHelper.rad(10)) + 0.5f * bodySwing + limbSwing;
        trailingLeg.field_3656 -= 0.8f;
        offsetX = trailingLeg.field_3657;
        offsetY = trailingLeg.field_3656;
        trailingLeg.field_3657 = offsetX * class_3532.method_15362(bodySwing) - offsetY * class_3532.method_15374(bodySwing);
        trailingLeg.field_3656 = offsetX * class_3532.method_15374(bodySwing) + offsetY * class_3532.method_15362(bodySwing);
        trailingLeg.field_3654 = AngleHelper.rad(10);
        trailingLeg.field_3674 = (isLeftArmMain ? -1 : 1) * (-AngleHelper.rad(10)) + 0.5f * bodySwing + limbSwing;
        model.field_3394.field_3657 -= armPivotX;
        model.field_3398.field_3657 -= armPivotX;
        model.field_3391.field_3657 -= armPivotX;
        otherArm.field_3657 -= armPivotX;
        trailingLeg.field_3657 -= armPivotX;
        leadingLeg.field_3657 -= armPivotX;

        model.field_3394.field_3656 -= armPivotY;
        model.field_3398.field_3656 -= armPivotY;
        model.field_3391.field_3656 -= armPivotY;
        otherArm.field_3656 -= armPivotY;
        trailingLeg.field_3656 -= armPivotY;
        leadingLeg.field_3656 -= armPivotY;
    }

}
