package com.zurrtum.create.client.infrastructure.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9326;

public record FluidConfig(
    Supplier<class_1058> still, Supplier<class_1058> flowing, Function<class_9326, Integer> tint, Supplier<Float> fogDistance, int fogColor
) {
    private static final Map<FluidConfig, class_1058[]> CACHE = new IdentityHashMap<>();

    @SuppressWarnings("deprecation")
    public FluidConfig(class_2960 still, class_2960 flowing, int tint, Supplier<Float> fogDistance, int fogColor) {
        this(
            () -> class_310.method_1551().method_1549(class_1059.field_5275).apply(still),
            () -> class_310.method_1551().method_1549(class_1059.field_5275).apply(flowing),
            stack -> tint,
            fogDistance,
            fogColor
        );
    }

    public FluidConfig(Supplier<class_1058> still, Supplier<class_1058> flowing, Function<class_9326, Integer> tint) {
        this(still, flowing, tint, () -> 0f, -1);
    }

    public class_1058[] toSprite() {
        return CACHE.computeIfAbsent(this, config -> new class_1058[]{config.still.get(), config.flowing.get()});
    }
}
