package com.zurrtum.create.client.infrastructure.model;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.model.BakedQuadHelper;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class TableClothModel extends WrapperBlockStateModel {
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034};
    private static final int SOUTH_WEST = 0b0011;
    private static final int NORTH_WEST = 0b0110;
    private static final int NORTH_EAST = 0b1100;
    private static final int SOUTH_EAST = 0b1001;

    private final BakedCorner[] corner = new BakedCorner[16];
    private List<class_777> south;
    private List<class_777> west;
    private List<class_777> north;
    private List<class_777> east;

    public TableClothModel(class_2680 state, class_9979 unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        model.method_68513(random, parts);
        int index = 0;
        class_2339 mutable = new class_2339();
        for (int i = 0; i < 4; i++) {
            class_2350 direction = DIRECTIONS[i];
            if (class_2248.method_9607(state, world.method_8320(mutable.method_25505(pos, direction)), direction)) {
                index |= (1 << i);
            }
        }
        BakedCorner cache = corner[index];
        if (cache != null) {
            parts.add(cache);
            return;
        }
        class_1058 sprite = model.method_68511();
        parts.add(corner[index] = new BakedCorner(
            (index & SOUTH_WEST) == SOUTH_WEST ? getSouth(sprite) : List.of(),
            (index & NORTH_WEST) == NORTH_WEST ? getWest(sprite) : List.of(),
            (index & NORTH_EAST) == NORTH_EAST ? getNorth(sprite) : List.of(),
            (index & SOUTH_EAST) == SOUTH_EAST ? getEast(sprite) : List.of(),
            sprite
        ));
    }

    private List<class_777> getSouth(class_1058 sprite) {
        if (south != null) {
            return south;
        }
        return south = replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SW);
    }

    private List<class_777> getWest(class_1058 sprite) {
        if (west != null) {
            return west;
        }
        return west = replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NW);
    }

    private List<class_777> getNorth(class_1058 sprite) {
        if (north != null) {
            return north;
        }
        return north = replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NE);
    }

    private List<class_777> getEast(class_1058 sprite) {
        if (east != null) {
            return east;
        }
        return east = replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SE);
    }

    private static List<class_777> replaceQuads(class_1058 replace, PartialModel model) {
        ImmutableList.Builder<class_777> builder = ImmutableList.builder();
        for (class_777 quad : model.get().comp_3750().method_68048()) {
            builder.add(replaceQuad(replace, quad));
        }
        return builder.build();
    }

    private static class_777 replaceQuad(class_1058 replace, class_777 quad) {
        class_1058 original = quad.comp_3724();
        if (original == replace) {
            return quad;
        }
        class_777 newQuad = BakedQuadHelper.clone(quad);
        int[] vertexData = newQuad.comp_3721();
        for (int vertex = 0; vertex < 4; vertex++) {
            BakedQuadHelper.setU(
                vertexData,
                vertex,
                replace.method_4580(SpriteShiftEntry.getUnInterpolatedU(original, BakedQuadHelper.getU(vertexData, vertex)))
            );
            BakedQuadHelper.setV(
                vertexData,
                vertex,
                replace.method_4570(SpriteShiftEntry.getUnInterpolatedV(original, BakedQuadHelper.getV(vertexData, vertex)))
            );
        }
        return newQuad;
    }

    private record BakedCorner(
        List<class_777> south, List<class_777> west, List<class_777> north, List<class_777> east, class_1058 particleSprite
    ) implements class_10889 {
        @Override
        public List<class_777> method_68509(@Nullable class_2350 side) {
            return switch (side) {
                case SOUTH -> south;
                case WEST -> west;
                case NORTH -> north;
                case EAST -> east;
                case null, default -> List.of();
            };
        }

        @Override
        public boolean comp_3751() {
            return false;
        }
    }
}
