package com.zurrtum.create.client.infrastructure.particle;

import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_708;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomRotationParticle extends class_708 {

    protected boolean mirror;
    protected int loopLength;

    public CustomRotationParticle(class_638 worldIn, double x, double y, double z, class_4002 spriteSet, float yAccel) {
        super(worldIn, x, y, z, spriteSet, yAccel);
    }

    public void selectSpriteLoopingWithAge(class_4002 sprite) {
        int loopFrame = field_3866 % loopLength;
        this.method_18141(sprite.method_18138(loopFrame, loopLength));
    }

    public Quaternionf getCustomRotation(class_4184 camera, float partialTicks) {
        Quaternionf quaternion = new Quaternionf(camera.method_23767());
        if (this.field_3839 != 0.0F) {
            float angle = class_3532.method_16439(partialTicks, this.field_3857, this.field_3839);
            quaternion.mul(class_7833.field_40718.rotation(angle));
        }
        return quaternion;
    }

    @Override
    public void method_3074(class_4588 builder, class_4184 camera, float partialTicks) {
        class_243 cameraPos = camera.method_19326();
        float originX = (float) (class_3532.method_16436(partialTicks, field_3858, field_3874) - cameraPos.method_10216());
        float originY = (float) (class_3532.method_16436(partialTicks, field_3838, field_3854) - cameraPos.method_10214());
        float originZ = (float) (class_3532.method_16436(partialTicks, field_3856, field_3871) - cameraPos.method_10215());

        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0F, -1.0F, 0.0F), new Vector3f(-1.0F, 1.0F, 0.0F), new Vector3f(
            1.0F,
            1.0F,
            0.0F
        ), new Vector3f(1.0F, -1.0F, 0.0F)};
        float scale = method_18132(partialTicks);

        Quaternionf rotation = getCustomRotation(camera, partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.rotate(rotation);
            vertex.mul(scale);
            vertex.add(originX, originY, originZ);
        }

        float minU = mirror ? method_18134() : method_18133();
        float maxU = mirror ? method_18133() : method_18134();
        float minV = method_18135();
        float maxV = method_18136();
        //TODO ShadersModHelper.isShaderPackInUse()
        int brightness = false ? class_765.method_23687(12, 15) : method_3068(partialTicks);
        builder.method_22912(vertices[0].x(), vertices[0].y(), vertices[0].z()).method_22913(maxU, maxV).method_22915(field_3861, field_3842, field_3859, field_3841).method_60803(brightness);
        builder.method_22912(vertices[1].x(), vertices[1].y(), vertices[1].z()).method_22913(maxU, minV).method_22915(field_3861, field_3842, field_3859, field_3841).method_60803(brightness);
        builder.method_22912(vertices[2].x(), vertices[2].y(), vertices[2].z()).method_22913(minU, minV).method_22915(field_3861, field_3842, field_3859, field_3841).method_60803(brightness);
        builder.method_22912(vertices[3].x(), vertices[3].y(), vertices[3].z()).method_22913(minU, maxV).method_22915(field_3861, field_3842, field_3859, field_3841).method_60803(brightness);
    }
}
