package com.zurrtum.create.client.infrastructure.particle;


import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.content.equipment.goggles.GogglesItem;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_746;

public class RotationIndicatorParticle extends class_708 {

    protected float radius;
    protected float radius1;
    protected float radius2;
    protected float speed;
    protected class_2351 axis;
    protected class_243 origin;
    protected class_243 offset;

    private RotationIndicatorParticle(
        class_638 world,
        double x,
        double y,
        double z,
        int color,
        float radius1,
        float radius2,
        float speed,
        class_2351 axis,
        int lifeSpan,
        class_4002 sprite
    ) {
        super(world, x, y, z, sprite, 0);
        this.field_3852 = 0;
        this.field_3869 = 0;
        this.field_3850 = 0;
        this.origin = new class_243(x, y, z);
        this.field_17867 *= 0.75F;
        this.field_3847 = lifeSpan + this.field_3840.method_43048(32);
        this.method_3092(color);
        this.method_3093(Color.mixColors(color, 0xFFFFFF, .5f));
        this.method_18142(sprite);
        this.radius1 = radius1;
        this.radius = radius1;
        this.radius2 = radius2;
        this.speed = speed;
        this.axis = axis;
        this.offset = axis.method_10179() ? new class_243(0, 1, 0) : new class_243(1, 0, 0);
        method_3069(0, 0, 0);
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        radius += (radius2 - radius) * .1f;
    }

    @Override
    public void method_3074(class_4588 buffer, class_4184 renderInfo, float partialTicks) {
        super.method_3074(buffer, renderInfo, partialTicks);
    }

    public void method_3069(double x, double y, double z) {
        float time = AnimationTickHolder.getTicks(field_3851);
        float angle = ((time * speed) % 360) - (speed / 2 * field_3866 * (((float) field_3866) / field_3847));
        if (speed < 0 && axis.method_10178())
            angle += 180;
        class_243 position = VecHelper.rotate(this.offset.method_1021(radius), angle, axis).method_1019(origin);
        this.field_3874 = position.field_1352;
        this.field_3854 = position.field_1351;
        this.field_3871 = position.field_1350;
    }

    public static class Factory implements class_707<RotationIndicatorParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public class_703 createParticle(
            RotationIndicatorParticleData data,
            class_638 worldIn,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
        ) {
            class_310 mc = class_310.method_1551();
            class_746 player = mc.field_1724;
            if (worldIn == mc.field_1687 && (player == null || !GogglesItem.isWearingGoggles(player))) {
                return null;
            }
            return new RotationIndicatorParticle(
                worldIn,
                x,
                y,
                z,
                data.color(),
                data.radius1(),
                data.radius2(),
                data.speed(),
                data.axis(),
                data.lifeSpan(),
                this.spriteSet
            );
        }
    }

}