package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

public class SoulParticle extends CustomRotationParticle {

    protected int startTicks;
    protected int endTicks;
    protected int numLoops;

    protected int firstStartFrame = 0;
    protected int startFrames = 17;

    protected int firstLoopFrame = 17;
    protected int loopFrames = 16;

    protected int firstEndFrame = 33;
    protected int endFrames = 20;

    protected AnimationStage animationStage;

    protected int totalFrames = 53;
    protected int ticksPerFrame = 2;

    protected boolean isPerimeter = false;
    protected boolean isExpandingPerimeter = false;
    protected boolean isVisible = true;
    protected int perimeterFrames = 8;

    public SoulParticle(
        class_2400 type,
        class_4002 spriteSet,
        class_638 worldIn,
        double x,
        double y,
        double z,
        double vx,
        double vy,
        double vz
    ) {
        super(worldIn, x, y, z, spriteSet, 0);
        this.field_17867 = 0.5f;
        this.method_3080(this.field_17867, this.field_17867);

        this.loopLength = loopFrames + (int) (this.field_3840.method_43057() * 5f - 4f);
        this.startTicks = startFrames + (int) (this.field_3840.method_43057() * 5f - 4f);
        this.endTicks = endFrames + (int) (this.field_3840.method_43057() * 5f - 4f);
        this.numLoops = (int) (1f + this.field_3840.method_43057() * 2f);

        this.setFrame(0);
        this.field_21507 = true; // disable movement
        this.mirror = this.field_3840.method_43056();

        this.isPerimeter = type == AllParticleTypes.SOUL_PERIMETER;
        this.isExpandingPerimeter = type == AllParticleTypes.SOUL_EXPANDING_PERIMETER;
        this.animationStage = !isPerimeter ? new StartAnimation(this) : new PerimeterAnimation(this);
        if (isPerimeter) {
            field_3838 = y -= .5f - 1 / 128f;
            totalFrames = perimeterFrames;
            isVisible = false;
        }
    }

    @Override
    public void method_3070() {
        animationStage.tick();
        animationStage = animationStage.getNext();

        class_2338 pos = class_2338.method_49637(field_3874, field_3854, field_3871);
        if (animationStage == null)
            method_3085();
        if (!SoulPulseEffect.isDark(field_3851, pos)) {
            isVisible = true;
            if (!isPerimeter)
                method_3085();
        } else if (isPerimeter)
            isVisible = false;
    }

    @Override
    public void method_3074(class_4588 builder, class_4184 camera, float partialTicks) {
        if (!isVisible)
            return;
        super.method_3074(builder, camera, partialTicks);
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < totalFrames)
            method_18141(field_17866.method_18138(frame, totalFrames));
    }

    @Override
    public Quaternionf getCustomRotation(class_4184 camera, float partialTicks) {
        if (isPerimeter)
            return class_7833.field_40714.rotationDegrees(90);
        return new Quaternionf().rotationXYZ(0, -camera.method_19330() * class_3532.field_29847, 0);
    }

    public static abstract class AnimationStage {

        protected final SoulParticle particle;

        protected int ticks;
        protected int animAge;

        public AnimationStage(SoulParticle particle) {
            this.particle = particle;
        }

        public void tick() {
            ticks++;

            if (ticks % particle.ticksPerFrame == 0)
                animAge++;
        }

        public float getAnimAge() {
            return (float) animAge;
        }

        public abstract AnimationStage getNext();
    }

    public static class StartAnimation extends AnimationStage {

        public StartAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();

            particle.setFrame(particle.firstStartFrame + (int) (getAnimAge() / (float) particle.startTicks * particle.startFrames));
        }

        @Override
        public AnimationStage getNext() {
            if (animAge < particle.startTicks)
                return this;
            else
                return new LoopAnimation(particle);
        }
    }

    public static class LoopAnimation extends AnimationStage {

        int loops;

        public LoopAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();

            int loopTick = getLoopTick();

            if (loopTick == 0)
                loops++;

            particle.setFrame(particle.firstLoopFrame + loopTick);// (int) (((float) loopTick / (float)
            // particle.loopLength) * particle.loopFrames));

        }

        private int getLoopTick() {
            return animAge % particle.loopFrames;
        }

        @Override
        public AnimationStage getNext() {
            if (loops <= particle.numLoops)
                return this;
            else
                return new EndAnimation(particle);
        }
    }

    public static class EndAnimation extends AnimationStage {

        public EndAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();

            particle.setFrame(particle.firstEndFrame + (int) ((getAnimAge() / (float) particle.endTicks) * particle.endFrames));

        }

        @Override
        public AnimationStage getNext() {
            if (animAge < particle.endTicks)
                return this;
            else
                return null;
        }
    }

    public static class PerimeterAnimation extends AnimationStage {

        public PerimeterAnimation(SoulParticle particle) {
            super(particle);
        }

        @Override
        public void tick() {
            super.tick();
            particle.setFrame((int) getAnimAge() % particle.perimeterFrames);
        }

        @Override
        public AnimationStage getNext() {
            if (animAge < (particle.isExpandingPerimeter ? 8 : particle.startTicks + particle.endTicks + particle.numLoops * particle.loopLength))
                return this;
            else
                return null;
        }
    }
}
