package com.zurrtum.create.client.mixin;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.catnip.gui.render.*;
import com.zurrtum.create.client.foundation.gui.render.*;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderer;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderState;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderer;
import net.minecraft.class_11228;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_4597.class_4598;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_11228.class)
public class GuiRendererMixin {
    @WrapOperation(method = "<init>", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableMap;builder()Lcom/google/common/collect/ImmutableMap$Builder;"), remap = false)
    private ImmutableMap.Builder<Class<? extends class_11256>, class_11239<?>> addRenderer(
        Operation<ImmutableMap.Builder<Class<? extends class_11256>, class_11239<?>>> original,
        @Local(argsOnly = true) class_4598 vertexConsumers
    ) {
        ImmutableMap.Builder<Class<? extends class_11256>, class_11239<?>> builder = original.call();
        builder.put(ItemTransformRenderState.class, new ItemTransformElementRenderer(vertexConsumers));
        builder.put(BlockTransformRenderState.class, new BlockTransformElementRenderer(vertexConsumers));
        builder.put(PartialRenderState.class, new PartialElementRenderer(vertexConsumers));
        builder.put(BlazeBurnerRenderState.class, new BlazeBurnerElementRenderer(vertexConsumers));
        builder.put(PressBasinRenderState.class, new PressBasinRenderer(vertexConsumers));
        builder.put(PressRenderState.class, new PressRenderer(vertexConsumers));
        builder.put(MixingBasinRenderState.class, new MixingBasinRenderer(vertexConsumers));
        builder.put(BasinBlazeBurnerRenderState.class, new BasinBlazeBurnerRenderer(vertexConsumers));
        builder.put(MillstoneRenderState.class, new MillstoneRenderer(vertexConsumers));
        builder.put(SawRenderState.class, new SawRenderer(vertexConsumers));
        builder.put(CrushWheelRenderState.class, new CrushWheelRenderer(vertexConsumers));
        builder.put(DeployerRenderState.class, new DeployerRenderer(vertexConsumers));
        builder.put(ManualBlockRenderState.class, new ManualBlockRenderer(vertexConsumers));
        builder.put(SpoutRenderState.class, new SpoutRenderer(vertexConsumers));
        builder.put(CrafterRenderState.class, new CrafterRenderer(vertexConsumers));
        builder.put(DrainRenderState.class, new DrainRenderer(vertexConsumers));
        builder.put(SandPaperRenderState.class, new SandPaperRenderer(vertexConsumers));
        builder.put(TitleTextRenderState.class, new TitleTextRenderer(vertexConsumers));
        builder.put(SceneRenderState.class, new SceneRenderer(vertexConsumers));
        builder.put(FanRenderState.class, new FanRenderer(vertexConsumers));
        return builder;
    }
}
