package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

@Mixin(class_2818.class)
public abstract class WorldChunkMixin {
    @Shadow
    @Final
    class_1937 world;

    @Shadow
    public abstract Map<class_2338, class_2586> getBlockEntities();

    @Inject(method = "setBlockEntity(Lnet/minecraft/block/entity/BlockEntity;)V", at = @At(value = "INVOKE_ASSIGN", target = "Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private void flywheel$onBlockEntityAdded(class_2586 blockEntity, CallbackInfo ci) {
        VisualizationManager manager = VisualizationManager.get(world);
        if (manager == null) {
            return;
        }

        manager.blockEntities().queueAdd(blockEntity);
    }

    @Inject(method = "clear()V", at = @At("HEAD"))
    private void clear(CallbackInfo ci) {
        getBlockEntities().values().forEach(blockEntity -> {
            if (blockEntity instanceof SmartBlockEntity sbe) {
                sbe.onChunkUnloaded();
            }
        });
    }
}
