package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.component.ShadowComponent;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4590;
import net.minecraft.class_8113;

public class BlockDisplayVisual extends AbstractEntityVisual<class_8113.class_8115> implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private class_2680 currentBlockState;

    private final ShadowComponent shadowComponent;

    public BlockDisplayVisual(VisualizationContext ctx, class_8113.class_8115 entity, float partialTick) {
        super(ctx, entity, partialTick);

        var blockRenderState = entity.method_49778();

        var state = blockRenderState != null ? blockRenderState.comp_1319() : class_2246.field_10124.method_9564();

        currentBlockState = state;

        instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(state)).createInstance();

        shadowComponent = new ShadowComponent(ctx, entity);
    }

    @Override
    public void beginFrame(Context ctx) {
        class_8113.class_8229 renderState = entity.method_49777();
        if (renderState == null) {
            instance.handle().setVisible(false);
            return;
        }
        var object = entity.method_49778();
        if (object == null) {
            instance.handle().setVisible(false);
            return;
        }

        instance.handle().setVisible(true);

        if (currentBlockState != object.comp_1319()) {
            currentBlockState = object.comp_1319();
            visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(currentBlockState)).stealInstance(instance);
        }

        float f = entity.method_48844(ctx.partialTick());

        shadowComponent.radius(renderState.comp_1331().method_48886(f));
        shadowComponent.strength(renderState.comp_1332().method_48886(f));
        shadowComponent.beginFrame(ctx);

        int i = renderState.comp_1330();
        int j = i != -1 ? i : computePackedLight(ctx.partialTick());
        class_4590 transformation = renderState.comp_1328().method_48888(f);

        class_243 pos = entity.method_19538();
        var renderOrigin = renderOrigin();

        instance.setIdentityTransform()
            .translate((float) (pos.field_1352 - renderOrigin.method_10263()), (float) (pos.field_1351 - renderOrigin.method_10264()), (float) (pos.field_1350 - renderOrigin.method_10260()));

        float partialTick = ctx.partialTick();
        class_4184 camera = ctx.camera();
        switch (renderState.comp_1329()) {
            case field_42406:
                instance.pose.rotateYXZ(
                    -0.017453292F * entityYRot(entity, partialTick),
                    ((float) Math.PI / 180F) * entityXRot(entity, partialTick),
                    0.0F
                );
                break;
            case field_42408:
                instance.pose.rotateYXZ(-0.017453292F * entityYRot(entity, partialTick), ((float) Math.PI / 180F) * cameraXRot(camera), 0.0F);
                break;
            case field_42407:
                instance.pose.rotateYXZ(-0.017453292F * cameraYrot(camera), ((float) Math.PI / 180F) * entityXRot(entity, partialTick), 0.0F);
                break;
            case field_42409:
                instance.pose.rotateYXZ(-0.017453292F * cameraYrot(camera), ((float) Math.PI / 180F) * cameraXRot(camera), 0.0F);
                break;
        }

        // getMatrix does a copy which is not strictly necessary here but oh well.
        instance.mul(transformation.method_22936()).light(j).setChanged();
    }

    private static float cameraYrot(class_4184 camera) {
        return camera.method_19330() - 180.0F;
    }

    private static float cameraXRot(class_4184 camera) {
        return -camera.method_19329();
    }

    private static float entityYRot(class_1297 entity, float partialTick) {
        return class_3532.method_17821(partialTick, entity.field_5982, entity.method_36454());
    }

    private static float entityXRot(class_1297 entity, float partialTick) {
        return class_3532.method_16439(partialTick, entity.field_6004, entity.method_36455());
    }

    @Override
    protected void _delete() {
        instance.delete();
    }
}
