package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity.ContraptionRotationState;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider.ContinuousSeparationManifold;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3499.class_3501;

public class ContraptionCollider {

    public enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER
    }

    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        class_1937 world = contraptionEntity.method_37908();
        Contraption contraption = contraptionEntity.getContraption();
        class_238 bounds = contraptionEntity.method_5829();

        if (contraption == null)
            return;
        if (bounds == null)
            return;

        class_243 contraptionPosition = contraptionEntity.method_19538();
        class_243 contraptionMotion = contraptionPosition.method_1020(contraptionEntity.getPrevPositionVec());
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        ContraptionRotationState rotation = null;

        // After death, multiple refs to the client player may show up in the area
        boolean skipClientPlayer = false;

        List<class_1297> entitiesWithinAABB = world.method_8390(class_1297.class, bounds.method_1014(2).method_1012(0, 32, 0), contraptionEntity::method_30949);
        for (class_1297 entity : entitiesWithinAABB) {
            if (!entity.method_5805())
                continue;

            PlayerType playerType = getPlayerType(entity);

            entity.method_24204().forEach(e -> {
                if (e instanceof class_3222 playerEntity)
                    playerEntity.field_13987.field_14138 = 0;
            });

            if (playerType == PlayerType.SERVER)
                continue;

            // Init matrix
            if (rotation == null)
                rotation = contraptionEntity.getRotationState();
            Matrix3d rotationMatrix = rotation.asMatrix();

            // Transform entity position and motion to local space
            class_243 entityPosition = entity.method_19538();
            class_238 entityBounds = entity.method_5829();
            class_243 motion = entity.method_18798();
            float yawOffset = rotation.getYawOffset();
            class_243 position = getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);

            motion = motion.method_1020(contraptionMotion);
            motion = rotationMatrix.transform(motion);

            // Prepare entity bounds
            class_238 localBB = entityBounds.method_997(position).method_1014(1.0E-7D);

            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);

            // Use simplified bbs when present
            final class_243 motionCopy = motion;
            List<class_238> collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {

                // Else find 'nearby' individual block shapes to collide with
                List<class_238> bbs = new ArrayList<>();
                List<class_265> potentialHits = getPotentiallyCollidedShapes(world, contraption, localBB.method_18804(motionCopy));
                potentialHits.forEach(shape -> bbs.addAll(shape.method_1090()));
                return bbs;

            });

            MutableObject<class_243> collisionResponse = new MutableObject<>(class_243.field_1353);
            MutableObject<class_243> normal = new MutableObject<>(class_243.field_1353);
            MutableObject<class_243> location = new MutableObject<>(class_243.field_1353);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1);
            class_243 obbCenter = obb.getCenter();

            // Apply separation maths
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean verticalPass = !horizontalPass || !doHorizontalPass;

                for (class_238 bb : collidableBBs) {
                    class_243 currentResponse = collisionResponse.getValue();
                    class_243 currentCenter = obbCenter.method_1019(currentResponse);

                    if (Math.abs(currentCenter.field_1352 - bb.method_1005().field_1352) - entityBounds.method_17939() - 1 > bb.method_17939() / 2)
                        continue;
                    if (Math.abs((currentCenter.field_1351 + motion.field_1351) - bb.method_1005().field_1351) - entityBounds.method_17940() - 1 > bb.method_17940() / 2)
                        continue;
                    if (Math.abs(currentCenter.field_1350 - bb.method_1005().field_1350) - entityBounds.method_17941() - 1 > bb.method_17941() / 2)
                        continue;

                    obb.setCenter(currentCenter);
                    ContinuousSeparationManifold intersect = obb.intersect(bb, motion);

                    if (intersect == null)
                        continue;
                    if (verticalPass && surfaceCollision.isFalse())
                        surfaceCollision.setValue(intersect.isSurfaceCollision());

                    double timeOfImpact = intersect.getTimeOfImpact();
                    boolean isTemporal = timeOfImpact > 0 && timeOfImpact < 1;
                    class_243 collidingNormal = intersect.getCollisionNormal();
                    class_243 collisionPosition = intersect.getCollisionPosition();

                    if (!isTemporal) {
                        class_243 separation = intersect.asSeparationVec(entity.method_49476());
                        if (separation != null && !separation.equals(class_243.field_1353)) {
                            collisionResponse.setValue(currentResponse.method_1019(separation));
                            timeOfImpact = 0;
                        }
                    }

                    boolean nearest = timeOfImpact >= 0 && temporalResponse.getValue() > timeOfImpact;
                    if (collidingNormal != null && nearest)
                        normal.setValue(collidingNormal);
                    if (collisionPosition != null && nearest)
                        location.setValue(collisionPosition);

                    if (isTemporal) {
                        if (temporalResponse.getValue() > timeOfImpact)
                            temporalResponse.setValue(timeOfImpact);
                    }
                }

                if (verticalPass)
                    break;

                boolean noVerticalMotionResponse = temporalResponse.getValue() == 1;
                boolean noVerticalCollision = collisionResponse.getValue().field_1351 == 0;
                if (noVerticalCollision && noVerticalMotionResponse)
                    break;

                // Re-run collisions with horizontal offset
                collisionResponse.setValue(collisionResponse.getValue().method_18805(129 / 128f, 0, 129 / 128f));
            }

            // Resolve collision
            class_243 entityMotion = entity.method_18798();
            class_243 entityMotionNoTemporal = entityMotion;
            class_243 collisionNormal = normal.getValue();
            class_243 collisionLocation = location.getValue();
            class_243 totalResponse = collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals(class_243.field_1353);
            boolean temporalCollision = temporalResponse.getValue() != 1;
            class_243 motionResponse = !temporalCollision ? motion : motion.method_1029().method_1021(motion.method_1033() * temporalResponse.getValue());

            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).method_1019(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, class_2351.field_11052);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, class_2351.field_11052);
            collisionNormal = collisionNormal.method_1029();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, class_2351.field_11052);
            rotationMatrix.transpose();

            double bounce = 0;
            double slide = 0;

            if (!collisionLocation.equals(class_243.field_1353)) {
                collisionLocation = collisionLocation.method_1019(entity.method_19538().method_1019(entity.method_5829().method_1005()).method_1021(.5f));
                if (temporalCollision)
                    collisionLocation = collisionLocation.method_1031(0, motionResponse.field_1351, 0);

                class_2338 pos = class_2338.method_49638(contraptionEntity.toLocalVector(entity.method_19538(), 0));
                if (contraption.getBlocks().containsKey(pos)) {
                    class_2680 blockState = contraption.getBlocks().get(pos).comp_1342();
                    if (blockState.method_26164(class_3481.field_22414)) {
                        surfaceCollision.setTrue();
                        totalResponse = totalResponse.method_1031(0, .1f, 0);
                    }
                }

                pos = class_2338.method_49638(contraptionEntity.toLocalVector(collisionLocation, 0));
                if (contraption.getBlocks().containsKey(pos)) {
                    class_2680 blockState = contraption.getBlocks().get(pos).comp_1342();

                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.interactors.get(pos);
                    if (movingInteractionBehaviour != null)
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);

                    bounce = BlockHelper.getBounceMultiplier(blockState.method_26204());
                    slide = Math.max(0, blockState.method_26204().method_9499() - .6f);
                }
            }

            boolean hasNormal = !collisionNormal.equals(class_243.field_1353);
            boolean anyCollision = hardCollision || temporalCollision;

            if (bounce > 0 && hasNormal && anyCollision && bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.method_37908()
                    .method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14560, class_3419.field_15245, .5f, 1);
                continue;
            }

            if (temporalCollision) {
                double idealVerticalMotion = motionResponse.field_1351;
                if (idealVerticalMotion != entityMotion.field_1351) {
                    entity.method_18799(entityMotion.method_18805(1, 0, 1).method_1031(0, idealVerticalMotion, 0));
                    entityMotion = entity.method_18798();
                }
            }

            if (hardCollision) {
                double motionX = entityMotion.method_10216();
                double motionY = entityMotion.method_10214();
                double motionZ = entityMotion.method_10215();
                double intersectX = totalResponse.method_10216();
                double intersectY = totalResponse.method_10214();
                double intersectZ = totalResponse.method_10215();

                double horizonalEpsilon = 1 / 128f;
                if (motionX != 0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0 == intersectX < 0)
                    entityMotion = entityMotion.method_18805(0, 1, 1);
                if (motionY != 0 && intersectY != 0 && motionY > 0 == intersectY < 0)
                    entityMotion = entityMotion.method_18805(1, 0, 1).method_1031(0, contraptionMotion.field_1351, 0);
                if (motionZ != 0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0 == intersectZ < 0)
                    entityMotion = entityMotion.method_18805(1, 1, 0);

            }

            if (bounce == 0 && slide > 0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.method_18805(1, 0, 1).method_1033() * 1.25f;
                class_243 motionIn = entityMotionNoTemporal.method_18805(0, .9, 0).method_1031(0, -.01f, 0);
                class_243 slideNormal = collisionNormal.method_1036(motionIn.method_1036(collisionNormal)).method_1029();
                class_243 newMotion = entityMotion.method_18805(.85, 0, .85)
                    .method_1019(slideNormal.method_1021((.2f + slide) * motionIn.method_1033() * slideFactor).method_1031(0, -.1f - collisionNormal.field_1351 * .125f, 0));
                entity.method_18799(newMotion);
                entityMotion = entity.method_18798();
            }

            if (!hardCollision && surfaceCollision.isFalse())
                continue;

            class_243 allowedMovement = collide(totalResponse, entity);
            entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351 + allowedMovement.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            entityPosition = entity.method_19538();

            entityMotion = handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);

            entity.field_6037 = true;
            class_243 contactPointMotion;

            if (surfaceCollision.isTrue()) {
                contraptionEntity.registerColliding(entity);
                entity.field_6017 = 0;
                boolean canWalk = bounce != 0 || slide == 0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk)
                        entity.method_24830(true);
                    if (entity instanceof class_1542)
                        entityMotion = entityMotion.method_18805(.5f, 1, .5f);
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = collide(contactPointMotion, entity);
                entity.method_5814(entityPosition.field_1352 + allowedMovement.field_1352, entityPosition.field_1351, entityPosition.field_1350 + allowedMovement.field_1350);
            }
            entity.method_18799(entityMotion);
        }
    }

    private static class_243 handleDamageFromTrain(
        class_1937 world,
        AbstractContraptionEntity contraptionEntity,
        class_243 contraptionMotion,
        class_1297 entity,
        class_243 entityMotion,
        PlayerType playerType
    ) {
        if (!(contraptionEntity instanceof CarriageContraptionEntity cce))
            return entityMotion;
        if (!entity.method_24828())
            return entityMotion;

        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity)) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }

        if (cce.collidingEntities.containsKey(entity))
            return entityMotion;
        if (entity instanceof class_1542)
            return entityMotion;
        if (cce.nonDamageTicks != 0)
            return entityMotion;
        if (!AllConfigs.server().trains.trainsCauseDamage.get())
            return entityMotion;

        class_243 diffMotion = contraptionMotion.method_1020(entity.method_18798());

        if (diffMotion.method_1033() <= 0.35f || contraptionMotion.method_1033() <= 0.35f)
            return entityMotion;

        class_1282 source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.method_1033();
        if (entity.method_5864().method_5891() == class_1311.field_6302)
            damage *= 2;

        if (entity instanceof class_1657 p && (p.method_68878() || p.method_7325()))
            return entityMotion;

        if (playerType != PlayerType.CLIENT) {
            class_3218 serverWorld = (class_3218) world;
            entity.method_64397(serverWorld, source, (int) (damage * 16));
            serverWorld.method_8396(null, entity.method_24515(), class_3417.field_15016, class_3419.field_15254, 1, .75f);
            if (!entity.method_5805())
                contraptionEntity.getControllingPlayer()
                    .ifPresent(uuid -> AllAdvancements.TRAIN_ROADKILL.trigger((class_3222) serverWorld.method_18470(uuid)));
        }

        class_243 added = entityMotion.method_1019(contraptionMotion.method_18805(1, 0, 1).method_1029().method_1031(0, .25, 0).method_1021(damage * 4)).method_1019(diffMotion);

        return VecHelper.clamp(added, 3);
    }

    public static boolean bounceEntity(class_1297 entity, class_243 normal, AbstractContraptionEntity contraption, double factor) {
        if (factor == 0)
            return false;
        if (entity.method_21750())
            return false;

        class_243 contactPointMotion = contraption.getContactPointMotion(entity.method_19538());
        class_243 motion = entity.method_18798().method_1020(contactPointMotion);
        class_243 deltav = normal.method_1021(factor * 2 * motion.method_1026(normal));
        if (deltav.method_1026(deltav) < 0.1f)
            return false;
        entity.method_18799(entity.method_18798().method_1020(deltav));
        return true;
    }

    public static class_243 getWorldToLocalTranslation(class_1297 entity, class_243 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        class_243 entityPosition = entity.method_19538();
        class_243 centerY = new class_243(0, entity.method_5829().method_17940() / 2, 0);
        class_243 position = entityPosition;
        position = position.method_1019(centerY);
        position = worldToLocalPos(position, anchorVec, rotationMatrix, yawOffset);
        position = position.method_1020(centerY);
        position = position.method_1020(entityPosition);
        return position;
    }

    public static class_243 worldToLocalPos(class_243 worldPos, AbstractContraptionEntity contraptionEntity) {
        return worldToLocalPos(worldPos, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static class_243 worldToLocalPos(class_243 worldPos, class_243 anchorVec, ContraptionRotationState rotation) {
        return worldToLocalPos(worldPos, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static class_243 worldToLocalPos(class_243 worldPos, class_243 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        class_243 localPos = worldPos;
        localPos = localPos.method_1020(anchorVec);
        localPos = localPos.method_1020(VecHelper.CENTER_OF_ORIGIN);
        localPos = VecHelper.rotate(localPos, -yawOffset, class_2351.field_11052);
        localPos = rotationMatrix.transform(localPos);
        localPos = localPos.method_1019(VecHelper.CENTER_OF_ORIGIN);
        return localPos;
    }

    /**
     * From Entity#collide
     **/
    public static class_243 collide(class_243 p_20273_, class_1297 e) {
        class_238 aabb = e.method_5829();
        List<class_265> list = e.method_37908().method_20743(e, aabb.method_18804(p_20273_));
        class_243 vec3 = p_20273_.method_1027() == 0.0D ? p_20273_ : class_1297.method_20736(e, p_20273_, aabb, e.method_37908(), list);
        boolean flag = p_20273_.field_1352 != vec3.field_1352;
        boolean flag1 = p_20273_.field_1351 != vec3.field_1351;
        boolean flag2 = p_20273_.field_1350 != vec3.field_1350;
        boolean flag3 = flag1 && p_20273_.field_1351 < 0.0D;
        if (e.method_49476() > 0.0F && flag3 && (flag || flag2)) {
            class_243 vec31 = class_1297.method_20736(e, new class_243(p_20273_.field_1352, e.method_49476(), p_20273_.field_1350), aabb, e.method_37908(), list);
            class_243 vec32 = class_1297.method_20736(
                e,
                new class_243(0.0D, e.method_49476(), 0.0D),
                aabb.method_1012(p_20273_.field_1352, 0.0D, p_20273_.field_1350),
                e.method_37908(),
                list
            );
            if (vec32.field_1351 < (double) e.method_49476()) {
                class_243 vec33 = class_1297.method_20736(e, new class_243(p_20273_.field_1352, 0.0D, p_20273_.field_1350), aabb.method_997(vec32), e.method_37908(), list)
                    .method_1019(vec32);
                if (vec33.method_37268() > vec31.method_37268()) {
                    vec31 = vec33;
                }
            }

            if (vec31.method_37268() > vec3.method_37268()) {
                return vec31.method_1019(class_1297.method_20736(
                    e,
                    new class_243(0.0D, -vec31.field_1351 + p_20273_.field_1351, 0.0D),
                    aabb.method_997(vec31),
                    e.method_37908(),
                    list
                ));
            }
        }

        return vec3;
    }

    private static PlayerType getPlayerType(class_1297 entity) {
        return entity instanceof class_1657 ? PlayerType.SERVER : PlayerType.NONE;
    }

    public static List<class_265> getPotentiallyCollidedShapes(class_1937 world, Contraption contraption, class_238 localBB) {
        double height = localBB.method_17940();
        double width = localBB.method_17939();
        double horizontalFactor = (height > width && width != 0) ? height / width : 1;
        double verticalFactor = (width > height && height != 0) ? width / height : 1;
        class_238 blockScanBB = localBB.method_1014(0.5f);
        blockScanBB = blockScanBB.method_1009(horizontalFactor, verticalFactor, horizontalFactor);

        class_2338 min = class_2338.method_49637(blockScanBB.field_1323, blockScanBB.field_1322, blockScanBB.field_1321);
        class_2338 max = class_2338.method_49637(blockScanBB.field_1320, blockScanBB.field_1325, blockScanBB.field_1324);

        List<class_265> potentialHits = new ArrayList<>();

        for (class_2338 p : class_2338.method_10097(min, max)) {
            if (contraption.blocks.containsKey(p) && !contraption.isHiddenInPortal(p)) {
                class_3501 info = contraption.getBlocks().get(p);

                class_2680 blockState = info.comp_1342();
                class_2338 pos = info.comp_1341();

                class_265 collisionShape = blockState.method_26220(world, p).method_1096(pos.method_10263(), pos.method_10264(), pos.method_10260());

                if (!collisionShape.method_1110()) {
                    potentialHits.add(collisionShape);
                }
            }
        }

        return potentialHits;
    }

    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision())
            return false;

        class_1937 world = contraptionEntity.method_37908();
        class_243 motion = contraptionEntity.method_18798();
        TranslatingContraption contraption = (TranslatingContraption) contraptionEntity.getContraption();
        class_238 bounds = contraptionEntity.method_5829();
        class_243 position = contraptionEntity.method_19538();
        class_2338 gridPos = class_2338.method_49638(position);

        if (contraption == null)
            return false;
        if (bounds == null)
            return false;
        if (motion.equals(class_243.field_1353))
            return false;

        class_2350 movementDirection = class_2350.method_10142(motion.field_1352, motion.field_1351, motion.field_1350);

        // Blocks in the world
        if (movementDirection.method_10171() == class_2352.field_11056)
            gridPos = gridPos.method_10093(movementDirection);
        if (isCollidingWithWorld(world, contraption, gridPos, movementDirection))
            return true;

        // Other moving Contraptions
        for (ControlledContraptionEntity otherContraptionEntity : world.method_8390(
            ControlledContraptionEntity.class,
            bounds.method_1014(1),
            e -> !e.equals(contraptionEntity)
        )) {

            if (!otherContraptionEntity.supportsTerrainCollision())
                continue;

            class_243 otherMotion = otherContraptionEntity.method_18798();
            TranslatingContraption otherContraption = (TranslatingContraption) otherContraptionEntity.getContraption();
            class_238 otherBounds = otherContraptionEntity.method_5829();
            class_243 otherPosition = otherContraptionEntity.method_19538();

            if (otherContraption == null)
                return false;
            if (otherBounds == null)
                return false;

            if (!bounds.method_997(motion).method_994(otherBounds.method_997(otherMotion)))
                continue;

            for (class_2338 colliderPos : contraption.getOrCreateColliders(world, movementDirection)) {
                colliderPos = colliderPos.method_10081(gridPos).method_10059(class_2338.method_49638(otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos))
                    continue;
                return true;
            }
        }

        return false;
    }

    public static boolean isCollidingWithWorld(class_1937 world, TranslatingContraption contraption, class_2338 anchor, class_2350 movementDirection) {
        for (class_2338 pos : contraption.getOrCreateColliders(world, movementDirection)) {
            class_2338 colliderPos = pos.method_10081(anchor);

            if (!world.method_8477(colliderPos))
                return true;

            class_2680 collidedState = world.method_8320(colliderPos);
            class_3501 blockInfo = contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.method_26220(world, pos).method_1110();

            if (collidedState.method_26204() instanceof class_2282)
                continue;

            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour behaviour) {
                    if (!behaviour.canBreak(world, colliderPos, collidedState) && !emptyCollider)
                        return true;
                    continue;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour harvesterMovementBehaviour) {
                    if (!harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) && !harvesterMovementBehaviour.isValidOther(
                        world,
                        colliderPos,
                        collidedState
                    ) && !emptyCollider)
                        return true;
                    continue;
                }
            }

            if (collidedState.method_27852(AllBlocks.PULLEY_MAGNET) && pos.equals(class_2338.field_11176) && movementDirection == class_2350.field_11036)
                continue;
            if (!collidedState.method_45474() && !emptyCollider) {
                return true;
            }

        }
        return false;
    }

}
