package com.zurrtum.create.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement.ElevatorFloorSelection;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.infrastructure.packet.s2c.ElevatorFloorListPacket;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3499.class_3501;

public class ElevatorContraption extends PulleyContraption {

    protected ColumnCoords column;
    protected int contactYOffset;
    public boolean arrived;

    private int namesListVersion = -1;
    public List<IntAttached<Couple<String>>> namesList = ImmutableList.of();
    public int clientYTarget;

    public int maxContactY;
    public int minContactY;

    // during assembly only
    private int contacts;

    public ElevatorContraption() {
        super();
    }

    public ElevatorContraption(int initialOffset) {
        super(initialOffset);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        super.tickStorage(entity);

        if (entity.field_6012 % 10 != 0)
            return;

        ColumnCoords coords = getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get(entity.method_37908(), coords);

        if (column == null)
            return;
        if (column.namesListVersion == namesListVersion)
            return;

        namesList = column.compileNamesList();
        namesListVersion = column.namesListVersion;
        if (entity.method_37908() instanceof class_3218 serverWorld) {
            serverWorld.method_14178().method_18754(entity, new ElevatorFloorListPacket(entity, namesList));
        }
    }

    @Override
    protected void disableActorOnStart(MovementContext context) {
    }

    public ColumnCoords getGlobalColumn() {
        return column.relative(anchor);
    }

    public Integer getCurrentTargetY(class_1937 level) {
        ColumnCoords coords = getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get(level, coords);
        if (column == null)
            return null;
        if (!column.isTargetAvailable())
            return null;
        int targetedYLevel = column.getTargetedYLevel();
        if (isTargetUnreachable(targetedYLevel))
            return null;
        return targetedYLevel;
    }

    public boolean isTargetUnreachable(int contactY) {
        return contactY < minContactY || contactY > maxContactY;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!searchMovedStructure(world, pos, null))
            return false;
        if (blocks.size() <= 0)
            return false;
        if (contacts == 0)
            throw new AssemblyException(class_2561.method_43471("create.gui.assembly.exception.no_contacts"));
        if (contacts > 1)
            throw new AssemblyException(class_2561.method_43471("create.gui.assembly.exception.too_many_contacts"));
        ElevatorColumn column = ElevatorColumn.get(world, getGlobalColumn());
        if (column != null && column.isActive())
            throw new AssemblyException(class_2561.method_43471("create.gui.assembly.exception.column_conflict"));
        startMoving(world);
        return true;
    }

    @Override
    protected Pair<class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);

        if (!blockState.method_27852(AllBlocks.REDSTONE_CONTACT))
            return super.capture(world, pos);

        class_2350 facing = blockState.method_11654(RedstoneContactBlock.field_10927);
        if (facing.method_10166() == class_2351.field_11052)
            return super.capture(world, pos);

        contacts++;
        class_2338 local = toLocalPos(pos.method_10093(facing));
        column = new ColumnCoords(local.method_10263(), local.method_10260(), facing.method_10153());
        contactYOffset = local.method_10264();

        return super.capture(world, pos);
    }

    public int getContactYOffset() {
        return contactYOffset;
    }

    public void broadcastFloorData(class_1937 level, class_2338 contactPos) {
        ElevatorColumn column = ElevatorColumn.get(level, getGlobalColumn());
        if (!(level.method_8321(contactPos) instanceof ElevatorContactBlockEntity ecbe))
            return;
        if (column != null)
            column.floorReached(level, ecbe.shortName);
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71472("Arrived", arrived);
        view.method_71468("Column", ColumnCoords.CODEC, column);
        view.method_71465("ContactY", contactYOffset);
        view.method_71465("MaxContactY", maxContactY);
        view.method_71465("MinContactY", minContactY);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        arrived = view.method_71433("Arrived", false);
        column = view.method_71426("Column", ColumnCoords.CODEC).orElseThrow();
        contactYOffset = view.method_71424("ContactY", 0);
        maxContactY = view.method_71424("MaxContactY", 0);
        minContactY = view.method_71424("MinContactY", 0);
        super.read(world, view, spawnData);
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.ELEVATOR;
    }

    public void setClientYTarget(int clientYTarget) {
        if (this.clientYTarget == clientYTarget)
            return;

        this.clientYTarget = clientYTarget;
        syncControlDisplays();
    }

    public void syncControlDisplays() {
        if (namesList.isEmpty())
            return;
        for (int i = 0; i < namesList.size(); i++)
            if (namesList.get(i).getFirst() == clientYTarget)
                setAllControlsToFloor(i);
    }

    public void setAllControlsToFloor(int floorIndex) {
        for (MutablePair<class_3501, MovementContext> pair : actors)
            if (pair.right != null && pair.right.temporaryData instanceof ElevatorFloorSelection efs)
                efs.currentIndex = floorIndex;
    }

}
