package com.zurrtum.create.content.decoration.slidingDoor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SlidingDoorBlockEntity extends SmartBlockEntity {

    public LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;

    public SlidingDoorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SLIDING_DOOR, pos, state);
        animation = LerpedFloat.linear().startWithValue(isOpen(state) ? 1 : 0);
    }

    @Override
    public void tick() {
        if (deferUpdate && !field_11863.method_8608()) {
            deferUpdate = false;
            class_2680 blockState = method_11010();
            blockState.method_26181(field_11863, field_11867, class_2246.field_10124, null, false);
        }

        super.tick();
        boolean open = isOpen(method_11010());
        boolean wasSettled = animation.settled();
        animation.chase(open ? 1 : 0, .15f, Chaser.LINEAR);
        animation.tickChaser();

        if (field_11863.method_8608()) {
            if (bridgeTicks < 2 && open)
                bridgeTicks++;
            else if (bridgeTicks > 0 && !open && isVisible(method_11010()))
                bridgeTicks--;
            return;
        }

        if (!open && !wasSettled && animation.settled() && !isVisible(method_11010()))
            showBlockModel();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(1);
    }

    protected boolean isVisible(class_2680 state) {
        return state.method_61767(SlidingDoorBlock.VISIBLE, true);
    }

    public boolean shouldRenderSpecial(class_2680 state) {
        return !isVisible(state) || bridgeTicks != 0;
    }

    protected void showBlockModel() {
        field_11863.method_8652(field_11867, method_11010().method_11657(SlidingDoorBlock.VISIBLE, true), class_2248.field_31036);
        field_11863.method_8396(null, field_11867, class_3417.field_14819, class_3419.field_15245, .5f, 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public static boolean isOpen(class_2680 state) {
        return state.method_61767(class_2323.field_10945, false);
    }

}
