package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.*;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.ComparatorUtil;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3532;
import net.minecraft.class_8824;
import net.minecraft.class_9323.class_9324;
import net.minecraft.class_9326;
import net.minecraft.class_9473;

public class BacktankBlockEntity extends KineticBlockEntity implements class_1275 {

    public int airLevel;
    public int airLevelTimer;
    private final class_2561 defaultName;
    private class_2561 customName;

    private int capacityEnchantLevel;

    private class_9326 componentPatch;

    public BacktankBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.BACKTANK, pos, state);
        defaultName = getDefaultName(state);
        componentPatch = class_9326.field_49588;
    }

    public static class_2561 getDefaultName(class_2680 state) {
        if (state.method_27852(AllBlocks.NETHERITE_BACKTANK)) {
            AllItems.NETHERITE_BACKTANK.method_63680();
        }

        return AllItems.COPPER_BACKTANK.method_63680();
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.BACKTANK);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (getSpeed() != 0)
            award(AllAdvancements.BACKTANK);
    }

    @Override
    public void tick() {
        super.tick();
        if (getSpeed() == 0)
            return;

        class_2680 state = method_11010();
        class_2746 waterProperty = class_2741.field_12508;
        if (state.method_28498(waterProperty) && state.method_11654(waterProperty))
            return;

        if (airLevelTimer > 0) {
            airLevelTimer--;
            return;
        }

        int max = BacktankUtil.maxAir(capacityEnchantLevel);
        if (field_11863.field_9236) {
            class_243 centerOf = VecHelper.getCenterOf(field_11867);
            class_243 v = VecHelper.offsetRandomly(centerOf, field_11863.field_9229, .65f);
            class_243 m = centerOf.method_1020(v);
            if (airLevel != max)
                field_11863.method_8406(new AirParticleData(1, .05f), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
            return;
        }

        if (airLevel == max)
            return;

        int prevComparatorLevel = getComparatorOutput();
        float abs = Math.abs(getSpeed());
        int increment = class_3532.method_15340(((int) abs - 100) / 20, 1, 5);
        airLevel = Math.min(max, airLevel + increment);
        if (getComparatorOutput() != prevComparatorLevel && !field_11863.field_9236)
            field_11863.method_8455(field_11867, state.method_26204());
        if (airLevel == max)
            sendData();
        airLevelTimer = class_3532.method_15340((int) (128f - abs / 5f) - 108, 0, 20);
    }

    public int getComparatorOutput() {
        int max = BacktankUtil.maxAir(capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel(airLevel / (float) max);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("Air", airLevel);
        view.method_71465("Timer", airLevelTimer);
        view.method_71465("CapacityEnchantment", capacityEnchantLevel);

        if (customName != null)
            view.method_71468("CustomName", class_8824.field_46597, customName);

        view.method_71468("Components", class_9326.field_49589, componentPatch);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        int prev = airLevel;
        airLevel = view.method_71424("Air", 0);
        airLevelTimer = view.method_71424("Timer", 0);
        capacityEnchantLevel = view.method_71424("CapacityEnchantment", 0);

        customName = view.method_71426("CustomName", class_8824.field_46597).orElse(null);
        componentPatch = view.method_71426("Components", class_9326.field_49589).orElse(class_9326.field_49588);
        if (prev != 0 && prev != airLevel && airLevel == BacktankUtil.maxAir(capacityEnchantLevel) && clientPacket)
            playFilledEffect();
    }

    @Override
    protected void method_57568(class_9473 componentInput) {
        setAirLevel(componentInput.method_58695(AllDataComponents.BACKTANK_AIR, 0));
    }

    @Override
    protected void method_57567(class_9324 components) {
        components.method_57840(AllDataComponents.BACKTANK_AIR, airLevel);
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(field_11863, field_11867, 0.4f, 1, true);
        class_243 baseMotion = new class_243(.25, 0.1, 0);
        class_243 baseVec = VecHelper.getCenterOf(field_11867);
        for (int i = 0; i < 360; i += 10) {
            class_243 m = VecHelper.rotate(baseMotion, i, class_2351.field_11052);
            class_243 v = baseVec.method_1019(m.method_1029().method_1021(.25f));

            field_11863.method_8406(class_2398.field_11228, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    @Override
    public class_2561 method_5477() {
        return this.customName != null ? this.customName : defaultName;
    }

    public int getAirLevel() {
        return airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        sendData();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }

    public void setComponentPatch(class_9326 componentPatch) {
        this.componentPatch = componentPatch;
    }

    public class_9326 getComponentPatch() {
        return componentPatch;
    }

}
