package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllBlockEntityTypes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class HauntedBellBlockEntity extends AbstractBellBlockEntity {

    public static final int DISTANCE = 10;
    public static final int RECHARGE_TICKS = 65;
    public static final int EFFECT_TICKS = 20;

    public int effectTicks = 0;

    public HauntedBellBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HAUNTED_BELL, pos, state);
    }

    @Override
    public boolean ring(class_1937 world, class_2338 pos, class_2350 direction) {
        if (isRinging && ringingTicks < RECHARGE_TICKS)
            return false;
        if (world instanceof class_3218 serverLevel)
            HauntedBellPulser.sendPulse(serverLevel, pos, DISTANCE, false);
        effectTicks = EFFECT_TICKS;
        return super.ring(world, pos, direction);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("EffectTicks", effectTicks);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        effectTicks = view.method_71424("EffectTicks", 0);
    }

    @Override
    public void tick() {
        super.tick();

        if (effectTicks <= 0)
            return;
        effectTicks--;

        if (!field_11863.field_9236)
            return;

        class_5819 rand = field_11863.method_8409();
        if (rand.method_43057() > 0.25f)
            return;

        spawnParticle(rand);
        playSound(rand);
    }

    protected void spawnParticle(class_5819 rand) {
        double x = field_11867.method_10263() + rand.method_43058();
        double y = field_11867.method_10264() + 0.5;
        double z = field_11867.method_10260() + rand.method_43058();
        double vx = rand.method_43058() * 0.04 - 0.02;
        double vy = 0.1;
        double vz = rand.method_43058() * 0.04 - 0.02;
        field_11863.method_8406(class_2398.field_23114, x, y, z, vx, vy, vz);
    }

    protected void playSound(class_5819 rand) {
        float vol = rand.method_43057() * 0.4F + rand.method_43057() > 0.9F ? 0.6F : 0.0F;
        float pitch = 0.6F + rand.method_43057() * 0.4F;
        field_11863.method_8396(null, field_11867, class_3417.field_23060.comp_349(), class_3419.field_15245, vol, pitch);
    }

}
