package com.zurrtum.create.content.fluids;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class FluidReactions {
    public static void handlePipeFlowCollision(class_1937 level, class_2338 pos, FluidStack fluid, FluidStack fluid2) {
        class_3611 f1 = fluid.getFluid();
        class_3611 f2 = fluid2.getFluid();

        AdvancementBehaviour.tryAward(level, pos, AllAdvancements.CROSS_STREAMS);
        BlockHelper.destroyBlock(level, pos, 1);

        class_2680 state = AllFlowCollision.Flow.get(new AllFlowCollision.FlowEntry(f1, f2));
        if (state != null) {
            level.method_8501(pos, state);
        }
    }

    public static void handlePipeSpillCollision(class_1937 level, class_2338 pos, class_3611 pipeFluid, class_3610 worldFluid) {
        class_3611 pf = FluidHelper.convertToStill(pipeFluid);
        class_3611 wf = worldFluid.method_15772();

        class_2680 state = AllFlowCollision.Spill.get(new AllFlowCollision.SpillEntry(wf, pf));
        if (state != null) {
            level.method_8501(pos, state);
        }
    }
}
