package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8786;
import net.minecraft.class_9696;

public class GenericItemEmptying {

    public static boolean canItemBeEmptied(class_1937 world, class_1799 stack) {
        if (PotionFluidHandler.isPotionItem(stack))
            return true;

        if (world.field_9236 ? world.method_8433().method_64678(AllRecipeSets.EMPTYING).method_64701(stack) : ((class_3218) world).method_64577()
            .method_8132(AllRecipeTypes.EMPTYING, new class_9696(stack), world).isPresent()) {
            return true;
        }

        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack)) {
            if (capability == null) {
                return false;
            }
            return capability.stream().anyMatch(fluidStack -> fluidStack.getAmount() > 0);
        }
    }

    public static Pair<FluidStack, class_1799> emptyItem(class_1937 world, class_1799 stack, boolean simulate) {
        if (PotionFluidHandler.isPotionItem(stack))
            return PotionFluidHandler.emptyPotion(stack, simulate);

        //TODO client check recipe
        if (!world.field_9236) {
            Optional<class_8786<EmptyingRecipe>> recipe = ((class_3218) world).method_64577()
                .method_8132(AllRecipeTypes.EMPTYING, new class_9696(stack), world);
            if (recipe.isPresent()) {
                if (!simulate)
                    stack.method_7934(1);
                EmptyingRecipe emptyingRecipe = recipe.get().comp_1933();
                return Pair.of(emptyingRecipe.fluidResult(), emptyingRecipe.result());
            }
        } else {
            //TODO
            //            Create.LOGGER.warn("Client check recipe " + stack.getName().getString());
        }

        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_46651(1))) {
            if (capability == null)
                return Pair.of(FluidStack.EMPTY, class_1799.field_8037);
            Optional<FluidStack> findFluid = capability.stream().filter(fluid -> fluid.getAmount() >= BucketFluidInventory.CAPACITY).findFirst();
            if (findFluid.isEmpty()) {
                return Pair.of(FluidStack.EMPTY, class_1799.field_8037);
            }
            FluidStack resultingFluid = findFluid.get();
            capability.extract(resultingFluid);
            if (!simulate)
                stack.method_7934(1);

            return Pair.of(resultingFluid, capability.getContainer());
        }
    }

}
