package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.class_1799;

public class ItemHandlerBeltSegment implements ItemInventory {
    private final BeltInventory beltInventory;
    private final int offset;

    public ItemHandlerBeltSegment(BeltInventory beltInventory, int offset) {
        this.beltInventory = beltInventory;
        this.offset = offset;
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return beltInventory.canInsertAt(offset);
    }

    @Override
    public boolean method_5442() {
        TransportedItemStack transported = beltInventory.getStackAtOffset(offset);
        return transported == null || transported.stack.method_7960();
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot != 0)
            return class_1799.field_8037;
        TransportedItemStack stackAtOffset = beltInventory.getStackAtOffset(offset);
        if (stackAtOffset == null)
            return class_1799.field_8037;
        return stackAtOffset.stack;
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        if (slot != 0)
            return class_1799.field_8037;
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(offset);
        if (transported == null)
            return class_1799.field_8037;

        amount = Math.min(amount, transported.stack.method_7947());
        class_1799 extracted = transported.stack.method_7971(amount);
        if (transported.stack.method_7960())
            beltInventory.toRemove.add(transported);
        else
            method_5431();
        return extracted;
    }

    @Override
    public class_1799 method_5441(int slot) {
        if (slot != 0)
            return class_1799.field_8037;
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(offset);
        if (transported == null)
            return class_1799.field_8037;
        beltInventory.toRemove.add(transported);
        class_1799 stack = transported.stack.method_7972();
        transported.stack.method_7939(0);
        return stack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot != 0) {
            return;
        }
        if (stack.method_7960()) {
            TransportedItemStack transported = this.beltInventory.getStackAtOffset(offset);
            if (transported == null || transported.stack.method_7960())
                return;
            beltInventory.toRemove.add(transported);
            transported.stack.method_7939(0);
        } else {
            TransportedItemStack newStack = new TransportedItemStack(stack);
            newStack.insertedAt = offset;
            newStack.beltPosition = offset + .5f + (beltInventory.beltMovementPositive ? -1 : 1) / 16f;
            newStack.prevBeltPosition = newStack.beltPosition;
            beltInventory.addItem(newStack);
        }
    }

    @Override
    public void method_5431() {
        beltInventory.belt.notifyUpdate();
    }

    @Override
    public int method_58350(class_1799 stack) {
        return Math.min(stack.method_7914(), 64);
    }
}
