package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class HandCrankBlockEntity extends GeneratingKineticBlockEntity {

    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public HandCrankBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HAND_CRANK, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;

        if (getGeneratedSpeed() == 0 || back != backwards)
            update = true;

        inUse = 10;
        this.backwards = back;
        if (update && !field_11863.field_9236)
            updateGeneratedRotation();
    }

    @Override
    public float getGeneratedSpeed() {
        class_2248 block = method_11010().method_26204();
        if (!(block instanceof HandCrankBlock crank))
            return 0;
        int speed = (inUse == 0 ? 0 : clockwise() ? -1 : 1) * crank.getRotationSpeed();
        return convertToDirection(speed, method_11010().method_11654(HandCrankBlock.FACING));
    }

    protected boolean clockwise() {
        return backwards;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("InUse", inUse);
        view.method_71472("Backwards", backwards);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        inUse = view.method_71424("InUse", 0);
        backwards = view.method_71433("Backwards", false);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();

        float actualSpeed = getSpeed();
        chasingVelocity += ((actualSpeed * 10 / 3f) - chasingVelocity) * .25f;
        independentAngle += chasingVelocity;

        if (inUse > 0) {
            inUse--;

            if (inUse == 0 && !field_11863.field_9236) {
                sequenceContext = null;
                updateGeneratedRotation();
            }
        }
    }

    @Override
    protected class_2248 getStressConfigKey() {
        return method_11010().method_27852(AllBlocks.HAND_CRANK) ? AllBlocks.HAND_CRANK : AllBlocks.COPPER_VALVE_HANDLE;
    }

}
