package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_8942;

import static com.zurrtum.create.Create.LOGGER;

public class DeployerMovementBehaviour extends MovementBehaviour {
    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(DeployerBlock.FACING).method_62675()).method_1021(2);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236)
            return;

        tryGrabbingItem(context);
        DeployerPlayer player = getPlayer(context);
        Mode mode = getMode(context);
        if (mode == Mode.USE && !DeployerHandler.shouldActivate(player.cast().method_6047(), context.world, pos, null))
            return;

        activate(context, pos, player, mode);
        checkForTrackPlacementAdvancement(context, player);
        tryDisposeOfExcess(context);
        context.stall = player.getBlockBreakingProgress() != null;
    }

    public void activate(MovementContext context, class_2338 pos, DeployerPlayer player, Mode mode) {
        class_1937 world = context.world;

        player.setPlacedTracks(false);

        FilterItemStack filter = context.getFilterFromBE();
        if (filter.item().method_31574(AllItems.SCHEMATIC)) {
            activateAsSchematicPrinter(context, pos, player, world, filter.item());
            return;
        }

        class_243 facingVec = class_243.method_24954(context.state.method_11654(DeployerBlock.FACING).method_62675());
        facingVec = context.rotation.apply(facingVec);
        class_243 vec = context.position.method_1020(facingVec.method_1021(2));

        float xRot = AbstractContraptionEntity.pitchFromVector(facingVec) - 90;
        if (Math.abs(xRot) > 89) {
            class_243 initial = new class_243(0, 0, 1);
            if (context.contraption.entity instanceof OrientedContraptionEntity oce)
                initial = VecHelper.rotate(initial, oce.getInitialYaw(), class_2351.field_11052);
            if (context.contraption.entity instanceof CarriageContraptionEntity cce)
                initial = VecHelper.rotate(initial, 90, class_2351.field_11052);
            facingVec = context.rotation.apply(initial);
        }

        class_3222 serverPlayer = player.cast();
        serverPlayer.method_36456(AbstractContraptionEntity.yawFromVector(facingVec));
        serverPlayer.method_36457(xRot);

        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void checkForTrackPlacementAdvancement(MovementContext context, DeployerPlayer player) {
        if ((context.contraption instanceof MountedContraption || context.contraption instanceof CarriageContraption) && player.getPlacedTracks() && context.blockEntityData != null) {
            context.blockEntityData.method_67491("Owner", class_4844.field_25122).ifPresent(uuid -> {
                if (context.world.method_18470(uuid) instanceof class_3222 serverPlayer) {
                    AllAdvancements.SELF_DEPLOYING.trigger(serverPlayer);
                }
            });
        }
    }

    protected void activateAsSchematicPrinter(MovementContext context, class_2338 pos, DeployerPlayer player, class_1937 world, class_1799 filter) {
        if (!filter.method_57826(AllDataComponents.SCHEMATIC_ANCHOR))
            return;
        if (!world.method_8320(pos).method_45474())
            return;

        if (!filter.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, false))
            return;
        SchematicLevel schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null)
            return;
        if (!schematicWorld.getBounds().method_14662(pos.method_10059(schematicWorld.anchor)))
            return;
        class_2680 blockState = schematicWorld.method_8320(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.method_8321(pos));
        if (requirement.isInvalid() || requirement.isEmpty())
            return;
        if (blockState.method_27852(AllBlocks.BELT))
            return;

        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        class_1799 contextStack = requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.getFirst().stack;

        if (!context.contraption.hasUniversalCreativeCrate) {
            class_1263 itemHandler = context.contraption.getStorage().getAllItems();
            for (ItemRequirement.StackRequirement required : requiredItems) {
                int count = required.stack.method_7947();
                int extract = itemHandler.countAll(required::matches, count);
                if (extract != count) {
                    return;
                }
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                contextStack = required.stack;
                itemHandler.extractAll(required::matches, contextStack.method_7947());
            }
        }

        class_2487 data = BlockHelper.prepareBlockEntityData(world, blockState, schematicWorld.method_8321(pos));
        BlockHelper.placeSchematicBlock(world, blockState, pos, contextStack, data);

        if (blockState.method_26204() instanceof class_2241 || blockState.method_26204() instanceof ITrackBlock)
            player.setPlacedTracks(true);
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_9236)
            return;
        if (!context.stall)
            return;

        DeployerPlayer player = getPlayer(context);
        Mode mode = getMode(context);

        Pair<class_2338, Float> blockBreakingProgress = player.getBlockBreakingProgress();
        if (blockBreakingProgress != null) {
            int timer = context.data.method_68083("Timer", 0);
            if (timer < 20) {
                timer++;
                context.data.method_10569("Timer", timer);
                return;
            }

            context.data.method_10551("Timer");
            activate(context, blockBreakingProgress.getKey(), player, mode);
            tryDisposeOfExcess(context);
        }

        context.stall = player.getBlockBreakingProgress() != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        if (context.world.field_9236)
            return;

        super.cancelStall(context);
        DeployerPlayer player = getPlayer(context);
        if (player == null)
            return;
        if (player.getBlockBreakingProgress() == null)
            return;
        context.world.method_8517(player.cast().method_5628(), player.getBlockBreakingProgress().getKey(), -1);
        player.setBlockBreakingProgress(null);
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.field_9236)
            return;

        DeployerPlayer player = getPlayer(context);
        if (player == null)
            return;

        class_3222 serverPlayer = player.cast();
        cancelStall(context);
        try (class_8942.class_11340 logging = new class_8942.class_11340(context.contraption.entity.method_71370(), LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, context.world.method_30349());
            serverPlayer.method_31548().method_7384(view.method_71467("Inventory", class_11343.field_60354));
            context.blockEntityData.method_67494("Inventory", class_2487.field_25128, view.method_71475());
        }
        serverPlayer.method_31472();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerPlayer player = getPlayer(context);
        if (player == null)
            return;
        class_3222 serverPlayer = player.cast();
        if (serverPlayer.method_6047().method_7960()) {
            FilterItemStack filter = context.getFilterFromBE();
            if (filter.item().method_31574(AllItems.SCHEMATIC))
                return;
            class_1799 held = context.contraption.getStorage().getAllItems().extract(stack -> filter.test(context.world, stack), 1);
            serverPlayer.method_6122(class_1268.field_5808, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerPlayer player = getPlayer(context);
        if (player == null)
            return;
        class_1661 inv = player.cast().method_31548();
        FilterItemStack filter = context.getFilterFromBE();

        class_2371<class_1799> main = inv.method_67533();
        int selected = inv.method_67532();
        for (int i = 0; i < main.size(); i++) {
            class_1799 stack = main.get(i);
            if (stack.method_7960() || i == selected && filter.test(context.world, stack))
                continue;
            dropItem(context, stack);
            main.set(i, class_1799.field_8037);
        }
        class_1661.field_56551.forEach((slot, equipmentSlot) -> {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960()) {
                return;
            }
            dropItem(context, stack);
            inv.method_5447(slot, class_1799.field_8037);
        });
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerPlayer player = getPlayer(context);
        if (player == null)
            return;
        class_1799 stack = player.cast().method_6047();
        if (stack.method_7960()) {
            return;
        }
        class_6903<class_2520> ops = context.world.method_30349().method_57093(class_2509.field_11560);
        context.data.method_67493("HeldItem", class_1799.field_24671, ops, stack);
    }

    private DeployerPlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerPlayer) && context.world instanceof class_3218) {
            class_5455 registryManager = context.world.method_30349();
            UUID owner = context.blockEntityData.method_67491("Owner", class_4844.field_25122).orElse(null);
            String ownerName = context.blockEntityData.method_67491("OwnerName", Codec.STRING).orElse(null);
            DeployerPlayer player = DeployerPlayer.create((class_3218) context.world, owner, ownerName);
            player.setOnMinecartContraption(context.contraption instanceof MountedContraption);

            try (class_8942.class_11340 logging = new class_8942.class_11340(context.contraption.entity.method_71370(), LOGGER)) {
                class_2487 inventory = context.blockEntityData.method_67491("Inventory", class_2487.field_25128).orElseGet(class_2487::new);
                class_11368 view = class_11352.method_71417(logging, registryManager, inventory);
                player.cast().method_31548().method_7397(view.method_71437("Inventory", class_11343.field_60354));
            }

            if (context.data.method_10545("HeldItem"))
                player.cast().method_6122(
                    class_1268.field_5808,
                    context.data.method_67492("HeldItem", class_1799.field_24671, registryManager.method_57093(class_2509.field_11560)).orElse(class_1799.field_8037)
                );
            context.blockEntityData.method_10551("Inventory");
            context.temporaryData = player;
        }
        return (DeployerPlayer) context.temporaryData;
    }

    private Mode getMode(MovementContext context) {
        return context.blockEntityData.method_67491("Mode", Mode.CODEC).orElse(Mode.PUNCH);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }
}
