package com.zurrtum.create.content.kinetics.mixer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public class MechanicalMixerBlockEntity extends BasinOperatingBlockEntity {

    private static final Object shapelessOrMixingRecipesKey = new Object();

    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalMixerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_MIXER, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        int localTick;
        float offset = 0;
        if (running) {
            if (runningTicks < 20) {
                localTick = runningTicks;
                float num = (localTick + partialTicks) / 20f;
                num = ((2 - class_3532.method_15362((float) (num * Math.PI))) / 2);
                offset = num - .5f;
            } else if (runningTicks <= 20) {
                offset = 1;
            } else {
                localTick = 40 - runningTicks;
                float num = (localTick - partialTicks) / 20f;
                num = ((2 - class_3532.method_15362((float) (num * Math.PI))) / 2);
                offset = num - .5f;
            }
        }
        return offset + 7 / 16f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = getSpeed();
        if (running) {
            if (runningTicks < 15) {
                return speed;
            }
            if (runningTicks <= 20) {
                return speed * 2;
            }
            return speed;
        }
        return speed / 2;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MIXER);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1012(0, -1.5, 0);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        running = view.method_71433("Running", false);
        runningTicks = view.method_71424("Ticks", 0);
        super.read(view, clientPacket);

        if (clientPacket && method_11002())
            getBasin().ifPresent(bte -> bte.setAreFluidsMoving(running && runningTicks <= 20));
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Running", running);
        view.method_71465("Ticks", runningTicks);
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();

        if (runningTicks >= 40) {
            running = false;
            runningTicks = 0;
            basinChecker.scheduleUpdate();
            return;
        }

        float speed = Math.abs(getSpeed());
        if (running && field_11863 != null) {
            if (field_11863.field_9236 && runningTicks == 20)
                renderParticles();

            if ((!field_11863.field_9236 || isVirtual()) && runningTicks == 20) {
                if (processingTicks < 0) {
                    float recipeSpeed = 1;
                    //TODO
                    //                    if (currentRecipe instanceof StandardProcessingRecipe) {
                    //                        int t = ((StandardProcessingRecipe<?>) currentRecipe).getProcessingDuration();
                    //                        if (t != 0)
                    //                            recipeSpeed = t / 100f;
                    //                    }

                    processingTicks = class_3532.method_15340((class_3532.method_15351((int) (512 / speed))) * class_3532.method_15386(recipeSpeed * 15) + 1, 1, 512);

                    Optional<BasinBlockEntity> basin = getBasin();
                    if (basin.isPresent()) {
                        Couple<SmartFluidTankBehaviour> tanks = basin.get().getTanks();
                        if (!tanks.getFirst().isEmpty() || !tanks.getSecond().isEmpty())
                            field_11863.method_8396(
                                null,
                                field_11867,
                                class_3417.field_14650,
                                class_3419.field_15245,
                                .75f,
                                speed < 65 ? .75f : 1.5f
                            );
                    }

                } else {
                    processingTicks--;
                    if (processingTicks == 0) {
                        runningTicks++;
                        processingTicks = -1;
                        applyBasinRecipe();
                        sendData();
                    }
                }
            }

            if (runningTicks != 20)
                runningTicks++;
        }
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = getBasin();
        if (basin.isEmpty() || field_11863 == null)
            return;

        BasinInventory inv = basin.get().itemCapability;
        for (int slot = 0, size = inv.method_5439(); slot < size; slot++) {
            class_1799 stackInSlot = inv.method_5438(slot);
            if (stackInSlot.method_7960())
                continue;
            class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
            spillParticle(data);
        }

        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null)
                continue;
            for (TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0))
                    continue;
                FluidStack stack = tankSegment.getRenderedFluid();
                spillParticle(new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, stack.getFluid(), stack.getComponentChanges()));
            }
        }
    }

    protected void spillParticle(class_2394 data) {
        float angle = field_11863.field_9229.method_43057() * 360;
        class_243 offset = new class_243(0, 0, 0.25f);
        offset = VecHelper.rotate(offset, angle, class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, getSpeed() > 0 ? 25 : -25, class_2351.field_11052).method_1031(0, .25f, 0);
        class_243 center = offset.method_1019(VecHelper.getCenterOf(field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), field_11863.field_9229, 1 / 128f);
        field_11863.method_8406(data, center.field_1352, center.field_1351 - 1.75f, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    protected boolean matchStaticFilters(class_8786<? extends class_1860<?>> recipe) {
        class_1860<?> r = recipe.comp_1933();
        if ((r instanceof class_1867 shapelessRecipe && AllConfigs.server().recipes.allowShapelessInMixer.get() && shapelessRecipe.field_9047.size() > 1 && !MechanicalPressBlockEntity.canCompress(
            r)) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe)) {
            return true;
        }
        class_3956<?> type = r.method_17716();
        if (type == AllRecipeTypes.POTION && AllConfigs.server().recipes.allowBrewingInMixer.get()) {
            return true;
        }
        return type == AllRecipeTypes.MIXING;
    }

    @Override
    public void startProcessingBasin() {
        if (running && runningTicks <= 20)
            return;
        super.startProcessingBasin();
        running = true;
        runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        runningTicks = 20;
        return true;
    }

    @Override
    protected void onBasinRemoved() {
        if (!running)
            return;
        runningTicks = 40;
        running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return running;
    }

    @Override
    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }
}
