package com.zurrtum.create.content.logistics.depot.storage;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3499.class_3501;

public class DepotMountedStorage extends WrapperMountedItemStorage<DepotMountedStorage.Handler> implements SyncedMountedStorage {
    public static final MapCodec<DepotMountedStorage> CODEC = TransportedItemStack.CODEC.optionalFieldOf("value")
        .xmap(DepotMountedStorage::new, DepotMountedStorage::getHeld);

    private boolean dirty;

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    protected DepotMountedStorage(Optional<TransportedItemStack> stack) {
        super(AllMountedStorageTypes.DEPOT);
        wrapped = new Handler(stack);
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        if (be instanceof DepotBlockEntity depot) {
            wrapped.getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    @Override
    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3501 info) {
        // interaction is handled in the Interaction Behavior, swaps items with the player
        return false;
    }

    @Override
    public void method_5431() {
        dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void afterSync(Contraption contraption, class_2338 localPos) {
        class_2586 be = contraption.presentBlockEntities.get(localPos);
        if (be instanceof DepotBlockEntity depot) {
            getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    public void setHeld(TransportedItemStack stack) {
        wrapped.setHeld(Optional.of(stack));
    }

    public void removeHeldItem() {
        wrapped.setHeld(Optional.empty());
    }

    public Optional<TransportedItemStack> getHeld() {
        return wrapped.getHeld();
    }

    public static DepotMountedStorage fromDepot(DepotBlockEntity depot) {
        TransportedItemStack held = depot.getHeldItem();
        return new DepotMountedStorage(held != null ? Optional.of(held.copy()) : Optional.empty());
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public class Handler implements ItemInventory {
        private Optional<TransportedItemStack> held;

        public Handler(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        @Override
        public int method_5439() {
            return 1;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot > 1) {
                return class_1799.field_8037;
            }
            return held.map(Handler::getHeldStack).orElse(class_1799.field_8037);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot > 1) {
                return;
            }
            if (stack.method_7960()) {
                this.held = Optional.empty();
            } else {
                this.held = Optional.of(new TransportedItemStack(stack));
            }
        }

        private static class_1799 getHeldStack(TransportedItemStack held) {
            return held.stack;
        }

        public Optional<TransportedItemStack> getHeld() {
            return held;
        }

        public void setHeld(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        @Override
        public void method_5431() {
            dirty = true;
        }
    }
}
