package com.zurrtum.create.content.logistics.packager;

import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class PackagerItemHandler implements class_1278 {
    private final int[] SLOTS = {0};
    private final PackagerBlockEntity blockEntity;

    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return blockEntity.heldBox.method_7960() && blockEntity.queuedExitingPackages.isEmpty();
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return PackageItem.isPackage(stack) && blockEntity.unwrapBox(stack, true);
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return blockEntity.animationTicks == 0;
    }

    @Override
    public int method_5439() {
        return 1;
    }

    public class_1799 getStack() {
        return blockEntity.heldBox;
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot != 0) {
            return class_1799.field_8037;
        }
        return blockEntity.heldBox;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot != 0) {
            return;
        }
        if (stack.method_7960()) {
            blockEntity.heldBox = stack;
        } else {
            blockEntity.unwrapBox(stack, false);
            blockEntity.triggerStockCheck();
        }
    }

    @Override
    public void method_5431() {
        blockEntity.notifyUpdate();
    }
}
