package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_6903;

public class BasinMovementBehaviour extends MovementBehaviour {
    private static final class_243 UP = class_243.method_24954(class_2350.field_11036.method_62675());

    @Override
    public void tick(MovementContext context) {
        if (context.temporaryData == null) {
            class_243 facingVec = context.rotation.apply(UP);
            if (class_2350.method_58251(facingVec) == class_2350.field_11033)
                dump(context, facingVec);
        }
    }

    @Nullable
    public static List<class_1799> readInventory(MovementContext context) {
        return context.blockEntityData.method_10562("Inventory").map(nbt -> {
            class_6903<class_2520> ops = context.world.method_30349().method_57093(class_2509.field_11560);
            List<class_1799> result = new ArrayList<>();
            nbt.method_10554("Input").ifPresent(list -> list.forEach(item -> class_1799.field_24671.parse(ops, item).ifSuccess(result::add)));
            nbt.method_10554("Output").ifPresent(list -> list.forEach(item -> class_1799.field_24671.parse(ops, item).ifSuccess(result::add)));
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }).orElse(null);
    }

    private void dump(MovementContext context, class_243 facingVec) {
        List<class_1799> inventory = readInventory(context);
        if (inventory == null) {
            return;
        }
        class_243 velocity = facingVec.method_1021(0.5);
        class_1937 world = context.world;
        for (class_1799 stack : inventory) {
            class_1542 item = new class_1542(world, context.position.field_1352, context.position.field_1351, context.position.field_1350, stack);
            item.method_18799(velocity);
            world.method_8649(item);
        }
        context.blockEntityData.method_10551("Inventory");
        class_2586 blockEntity = context.contraption.presentBlockEntities.get(context.localPos);
        if (blockEntity instanceof BasinBlockEntity basin) {
            basin.itemCapability.method_5448();
        }
        context.temporaryData = Boolean.TRUE;
    }
}
