package com.zurrtum.create.content.processing.burner;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import java.util.Locale;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2754;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class LitBlazeBurnerBlock extends class_2248 implements IWrenchable {

    //TODO
    //    public static final ItemAbility EXTINGUISH_FLAME_ACTION = ItemAbility.get(MOD_ID + ":extinguish_flame");

    public static final class_2754<FlameType> FLAME_TYPE = class_2754.method_11850("flame_type", FlameType.class);

    public LitBlazeBurnerBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(FLAME_TYPE, FlameType.REGULAR));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FLAME_TYPE);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (stack.method_7909() instanceof class_1821/* || stack.getItem().canPerformAction(stack, EXTINGUISH_FLAME_ACTION)*/) {
            level.method_8396(player, pos, class_3417.field_15222, class_3419.field_15245, 0.5f, 2);
            if (level.field_9236)
                return class_1269.field_5812;
            stack.method_7970(1, player, class_1304.field_6173);
            level.method_8501(pos, AllBlocks.BLAZE_BURNER.method_9564());
            return class_1269.field_5812;
        }

        if (state.method_11654(FLAME_TYPE) == FlameType.REGULAR) {
            if (stack.method_31573(class_3489.field_23801)) {
                level.method_8396(player, pos, class_3417.field_21951, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.4F + 0.8F);
                if (level.field_9236)
                    return class_1269.field_5812;
                level.method_8501(pos, method_9564().method_11657(FLAME_TYPE, FlameType.SOUL));
                return class_1269.field_5812;
            }
        }

        return class_1269.field_52423;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 reader, class_2338 pos, class_3726 context) {
        return AllBlocks.BLAZE_BURNER.method_9530(state, reader, pos, context);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.EMPTY_BLAZE_BURNER.method_7854();
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        world.method_17452(
            class_2398.field_11237,
            true,
            (double) pos.method_10263() + 0.5D + random.method_43058() / 3.0D * (double) (random.method_43056() ? 1 : -1),
            (double) pos.method_10264() + random.method_43058() + random.method_43058(),
            (double) pos.method_10260() + 0.5D + random.method_43058() / 3.0D * (double) (random.method_43056() ? 1 : -1),
            0.0D,
            0.07D,
            0.0D
        );

        if (random.method_43048(10) == 0) {
            world.method_8486(
                pos.method_10263() + 0.5F,
                pos.method_10264() + 0.5F,
                pos.method_10260() + 0.5F,
                class_3417.field_17483,
                class_3419.field_15245,
                0.25F + random.method_43057() * .25f,
                random.method_43057() * 0.7F + 0.6F,
                false
            );
        }

        if (state.method_11654(FLAME_TYPE) == FlameType.SOUL) {
            if (random.method_43048(8) == 0) {
                world.method_8406(
                    class_2398.field_23114,
                    pos.method_10263() + 0.5F + random.method_43058() / 4 * (random.method_43056() ? 1 : -1),
                    pos.method_10264() + 0.3F + random.method_43058() / 2,
                    pos.method_10260() + 0.5F + random.method_43058() / 4 * (random.method_43056() ? 1 : -1),
                    0.0,
                    random.method_43058() * 0.04 + 0.04,
                    0.0
                );
            }
            return;
        }

        if (random.method_43048(5) == 0) {
            for (int i = 0; i < random.method_43048(1) + 1; ++i) {
                world.method_8406(
                    class_2398.field_11239,
                    pos.method_10263() + 0.5F,
                    pos.method_10264() + 0.5F,
                    pos.method_10260() + 0.5F,
                    random.method_43057() / 2.0F,
                    5.0E-5D,
                    random.method_43057() / 2.0F
                );
            }
        }
    }

    @Override
    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 p_180641_2_, class_2338 p_180641_3_) {
        return state.method_11654(FLAME_TYPE) == FlameType.REGULAR ? 1 : 2;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 reader, class_2338 pos, class_3726 context) {
        return AllBlocks.BLAZE_BURNER.method_9549(state, reader, pos, context);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static int getLight(class_2680 state) {
        if (state.method_11654(FLAME_TYPE) == FlameType.SOUL)
            return 9;
        else
            return 12;
    }

    public enum FlameType implements class_3542 {

        REGULAR,
        SOUL;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

    }

}
