package com.zurrtum.create.content.trains.bogey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.util.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Function;

import static com.zurrtum.create.Create.MOD_ID;

public abstract class AbstractBogeyBlock<T extends AbstractBogeyBlockEntity> extends class_2248 implements IBE<T>, ProperWaterloggedBlock, SpecialBlockItemRequirement, IWrenchable {
    public static final class_9139<class_9129, AbstractBogeyBlock<?>> STREAM_CODEC = class_9135.method_56365(class_7924.field_41254)
        .method_56432(block -> (AbstractBogeyBlock<?>) block, Function.identity());
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    static final List<class_2960> BOGEYS = class_156.method_654(
        new ArrayList<>(), list -> {
            list.add(class_2960.method_60655(MOD_ID, "block/small_bogey"));
            list.add(class_2960.method_60655(MOD_ID, "block/large_bogey"));
        }
    );
    public BogeySize size;

    public AbstractBogeyBlock(class_2251 pProperties, BogeySize size) {
        super(pProperties);
        method_9590(method_9564().method_11657(WATERLOGGED, false));
        this.size = size;
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        TrackEdge currentEdge = point.edge;
        if (currentEdge == null)
            return false;
        return currentEdge.getTrackMaterial().getId() != getTrackType(bogey.getStyle());
    }

    public Set<class_2960> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of(getTrackType(style));
    }

    public abstract class_2960 getTrackType(BogeyStyle style);

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AXIS, WATERLOGGED);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pDirection,
        class_2338 pNeighborPos,
        class_2680 pNeighborState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    static final EnumSet<class_2350> STICKY_X = EnumSet.of(class_2350.field_11034, class_2350.field_11039);
    static final EnumSet<class_2350> STICKY_Z = EnumSet.of(class_2350.field_11035, class_2350.field_11043);

    public EnumSet<class_2350> getStickySurfaces(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_11654(class_2741.field_12529) == class_2350.class_2351.field_11048 ? STICKY_X : STICKY_Z;
    }

    public abstract double getWheelPointSpacing();

    public abstract double getWheelRadius();

    public class_243 getConnectorAnchorOffset(boolean upsideDown) {
        return getConnectorAnchorOffset();
    }

    /**
     * This should be implemented, but not called directly
     */
    protected abstract class_243 getConnectorAnchorOffset();

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public abstract BogeyStyle getDefaultStyle();

    /**
     * Legacy system doesn't capture bogey block entities when constructing a train
     */
    public boolean captureBlockEntityForTrain() {
        return false;
    }

    public BogeySize getSize() {
        return this.size;
    }

    public class_2350 getBogeyUpDirection() {
        return class_2350.field_11036;
    }

    public boolean isTrackAxisAlongFirstCoordinate(class_2680 state) {
        return state.method_11654(AXIS) == class_2350.class_2351.field_11048;
    }

    @Nullable
    public class_2680 getMatchingBogey(class_2350 upDirection, boolean axisAlongFirst) {
        if (upDirection != class_2350.field_11036)
            return null;
        return method_9564().method_11657(AXIS, axisAlongFirst ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (level.field_9236)
            return class_1269.field_52423;

        if (!player.method_5715() && stack.method_31574(AllItems.WRENCH) && !player.method_7357()
            .method_7904(stack) && AllBogeyStyles.BOGEY_STYLES.size() > 1) {

            class_2586 be = level.method_8321(pos);

            if (!(be instanceof AbstractBogeyBlockEntity sbbe))
                return class_1269.field_5814;

            player.method_7357().method_62835(stack, 20);
            BogeyStyle currentStyle = sbbe.getStyle();

            BogeySize size = getSize();

            BogeyStyle style = this.getNextStyle(currentStyle);
            if (style == currentStyle)
                return class_1269.field_52423;

            Set<BogeySize> validSizes = style.validSizes();

            for (int i = 0; i < AllBogeySizes.all().size(); i++) {
                if (validSizes.contains(size))
                    break;
                size = size.nextBySize();
            }

            sbbe.setBogeyStyle(style);

            class_2487 defaultData = style.defaultData;
            sbbe.setBogeyData(sbbe.getBogeyData().method_10543(defaultData));

            if (size == getSize()) {
                if (state.method_26204() != style.getBlockForSize(size)) {
                    class_2487 oldData = sbbe.getBogeyData();
                    level.method_8501(pos, copyProperties(state, getStateOfSize(sbbe, size)));
                    if (!(level.method_8321(pos) instanceof AbstractBogeyBlockEntity bogeyBlockEntity))
                        return class_1269.field_5814;
                    bogeyBlockEntity.setBogeyData(oldData);
                }
                player.method_7353(class_2561.method_43471("create.bogey.style.updated_style").method_27693(": ").method_10852(style.displayName), true);
            } else {
                class_2487 oldData = sbbe.getBogeyData();
                level.method_8501(pos, getStateOfSize(sbbe, size));
                if (!(level.method_8321(pos) instanceof AbstractBogeyBlockEntity bogeyBlockEntity))
                    return class_1269.field_5814;
                bogeyBlockEntity.setBogeyData(oldData);
                player.method_7353(class_2561.method_43471("create.bogey.style.updated_style_and_size").method_27693(": ").method_10852(style.displayName), true);
            }

            return class_1269.field_21466;
        }

        return onInteractWithBogey(state, level, pos, player, hand, hitResult);
    }

    // Allows for custom interactions with bogey block to be added simply
    protected class_1269 onInteractWithBogey(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return class_1269.field_52423;
    }

    /**
     * If, instead of using the style-based cycling system you prefer to use separate blocks, return them from this method
     */
    protected List<class_2960> getBogeyBlockCycle() {
        return BOGEYS;
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 state, class_2350 targetedFace) {
        class_2248 block = state.method_26204();
        List<class_2960> bogeyCycle = getBogeyBlockCycle();
        int indexOf = bogeyCycle.indexOf(RegisteredObjectsHelper.getKeyOrThrow(block));
        if (indexOf == -1)
            return state;
        int index = (indexOf + 1) % bogeyCycle.size();
        class_2350 bogeyUpDirection = getBogeyUpDirection();
        boolean trackAxisAlongFirstCoordinate = isTrackAxisAlongFirstCoordinate(state);

        while (index != indexOf) {
            class_2960 id = bogeyCycle.get(index);
            class_2248 newBlock = class_7923.field_41175.method_63535(id);
            if (newBlock instanceof AbstractBogeyBlock<?> bogey) {
                class_2680 matchingBogey = bogey.getMatchingBogey(bogeyUpDirection, trackAxisAlongFirstCoordinate);
                if (matchingBogey != null)
                    return copyProperties(state, matchingBogey);
            }
            index = (index + 1) % bogeyCycle.size();
        }

        return state;
    }

    public class_2680 getNextSize(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof AbstractBogeyBlockEntity sbbe)
            return this.getNextSize(sbbe);
        return level.method_8320(pos);
    }

    /**
     * List of BlockState Properties to copy between sizes
     */
    public List<class_2769<?>> propertiesToCopy() {
        return ImmutableList.of(WATERLOGGED, AXIS);
    }

    // generic method needed to satisfy Property and BlockState's generic requirements
    private <V extends Comparable<V>> class_2680 method_34724(class_2680 source, class_2680 target, class_2769<V> property) {
        if (source.method_28498(property) && target.method_28498(property)) {
            return target.method_11657(property, source.method_11654(property));
        }
        return target;
    }

    private class_2680 copyProperties(class_2680 source, class_2680 target) {
        for (class_2769<?> property : propertiesToCopy())
            target = method_34724(source, target, property);
        return target;
    }

    public class_2680 getNextSize(AbstractBogeyBlockEntity sbbe) {
        BogeySize size = this.getSize();
        BogeyStyle style = sbbe.getStyle();
        class_2680 nextBlock = style.getNextBlock(size).method_9564();
        nextBlock = copyProperties(sbbe.method_11010(), nextBlock);
        return nextBlock;
    }

    public class_2680 getStateOfSize(AbstractBogeyBlockEntity sbbe, BogeySize size) {
        BogeyStyle style = sbbe.getStyle();
        class_2680 state = style.getBlockForSize(size).method_9564();
        return copyProperties(sbbe.method_11010(), state);
    }

    public BogeyStyle getNextStyle(class_1937 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        if (te instanceof AbstractBogeyBlockEntity sbbe)
            return this.getNextStyle(sbbe.getStyle());
        return getDefaultStyle();
    }

    public BogeyStyle getNextStyle(BogeyStyle style) {
        Collection<BogeyStyle> allStyles = style.getCycleGroup().values();
        if (allStyles.size() <= 1)
            return style;
        List<BogeyStyle> list = new ArrayList<>(allStyles);
        return Iterate.cycleValue(list, style);
    }


    @Override
    public @NotNull class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRotation) {
        return switch (pRotation) {
            case field_11465, field_11463 -> pState.method_28493(AXIS);
            default -> pState;
        };
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllItems.RAILWAY_CASING.method_7854());
    }

    public boolean canBeUpsideDown() {
        return false;
    }

    public boolean isUpsideDown(class_2680 state) {
        return false;
    }

    public class_2680 getVersion(class_2680 base, boolean upsideDown) {
        return base;
    }
}
