package com.zurrtum.create.foundation.gui.menu;

import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public abstract class GhostItemMenu<T> extends MenuBase<T> implements IClearableMenu {

    public ItemStackHandler ghostInventory;

    protected GhostItemMenu(MenuType<T> type, int id, class_1661 inv, T contentHolder) {
        super(type, id, inv, contentHolder);
    }

    protected abstract ItemStackHandler createGhostInventory();

    protected abstract boolean allowRepeats();

    @Override
    protected void initAndReadInventory(T contentHolder) {
        ghostInventory = createGhostInventory();
    }

    @Override
    public void clearContents() {
        for (int i = 0, size = ghostInventory.method_5439(); i < size; i++)
            ghostInventory.method_5447(i, class_1799.field_8037);
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slotIn) {
        return slotIn.field_7871 == playerInventory;
    }

    @Override
    public boolean method_7615(class_1735 slotIn) {
        if (allowRepeats())
            return true;
        return slotIn.field_7871 == playerInventory;
    }

    @Override
    public void method_7593(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player) {
        if (slotId < 36) {
            super.method_7593(slotId, dragType, clickTypeIn, player);
            return;
        }
        if (clickTypeIn == class_1713.field_7795)
            return;

        class_1799 held = method_34255();
        int slot = slotId - 36;
        if (clickTypeIn == class_1713.field_7796) {
            if (player.method_68878() && held.method_7960()) {
                class_1799 stackInSlot = ghostInventory.method_5438(slot).method_7972();
                stackInSlot.method_7939(stackInSlot.method_7914());
                method_34254(stackInSlot);
                return;
            }
            return;
        }

        class_1799 insert;
        if (held.method_7960()) {
            insert = class_1799.field_8037;
        } else {
            insert = held.method_7972();
            insert.method_7939(1);
        }
        ghostInventory.method_5447(slot, insert);
        method_7611(slotId).method_7668();
    }

    @Override
    protected boolean method_7616(class_1799 pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        return false;
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        if (index < 36) {
            class_1799 stackToInsert = playerInventory.method_5438(index);
            for (int i = 0, size = ghostInventory.method_5439(); i < size; i++) {
                class_1799 stack = ghostInventory.method_5438(i);
                if (!allowRepeats() && class_1799.method_31577(stack, stackToInsert))
                    break;
                if (stack.method_7960()) {
                    class_1799 copy = stackToInsert.method_7972();
                    copy.method_7939(1);
                    ghostInventory.method_5447(i, copy);
                    method_7611(i + 36).method_7668();
                    break;
                }
            }
        } else {
            int i = index - 36;
            class_1799 stack = ghostInventory.method_5438(i);
            int count = stack.method_7947();
            if (count == 1) {
                ghostInventory.method_5447(i, class_1799.field_8037);
            } else if (count > 1) {
                stack.method_7939(count - 1);
            }
            method_7611(index).method_7668();
        }
        return class_1799.field_8037;
    }

}