package com.zurrtum.create.foundation.recipe;

import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.catnip.data.IntAttached;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public class ItemCopyingRecipe extends class_1852 {

    public interface SupportsItemCopying {

        default class_1799 createCopy(class_1799 original, int count) {
            class_1799 copyWithCount = original.method_46651(count);
            copyWithCount.method_57379(class_9334.field_49633, class_9304.field_49385);
            copyWithCount.method_57381(class_9334.field_49643);
            return copyWithCount;
        }

        default boolean canCopyFromItem(class_1799 item) {
            return item.method_57826(getComponentType());
        }

        default boolean canCopyToItem(class_1799 item) {
            return !item.method_57826(getComponentType());
        }

        class_9331<?> getComponentType();

    }

    public ItemCopyingRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_9694 input, class_1937 level) {
        return copyCheck(input) != null;
    }

    @Override
    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        IntAttached<class_1799> copyCheck = copyCheck(input);
        if (copyCheck == null)
            return class_1799.field_8037;

        class_1799 itemToCopy = copyCheck.getValue();
        if (!(itemToCopy.method_7909() instanceof SupportsItemCopying sic))
            return class_1799.field_8037;

        return sic.createCopy(itemToCopy, copyCheck.getFirst() + 1);
    }

    @Nullable
    private IntAttached<class_1799> copyCheck(class_9694 input) {
        class_1799 itemToCopy = class_1799.field_8037;
        int copyTargets = 0;

        for (int j = 0; j < input.method_59983(); ++j) {
            class_1799 itemInSlot = input.method_59984(j);
            if (itemInSlot.method_7960())
                continue;
            if (!itemToCopy.method_7960() && itemToCopy.method_7909() != itemInSlot.method_7909())
                return null;
            if (!(itemInSlot.method_7909() instanceof SupportsItemCopying sic))
                continue;

            if (sic.canCopyFromItem(itemInSlot)) {
                if (!itemToCopy.method_7960())
                    return null;
                itemToCopy = itemInSlot;
                continue;
            }

            if (sic.canCopyToItem(itemInSlot))
                copyTargets++;
        }

        if (itemToCopy.method_7960() || copyTargets == 0)
            return null;

        return IntAttached.with(copyTargets, itemToCopy);
    }

    @Override
    public class_1865<ItemCopyingRecipe> method_8119() {
        return AllRecipeSerializers.ITEM_COPYING;
    }
}
