package com.zurrtum.create.foundation.utility;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

public final class GlobalRegistryAccess {
    private static final Supplier<@Nullable class_5455> supplier;

    static {
        if (AllClientHandle.INSTANCE.isClient()) {
            supplier = () -> AllClientHandle.INSTANCE.getPlayer().method_56673();
        } else {
            supplier = () -> {
                MinecraftServer server = Create.SERVER;
                if (server == null) {
                    return null;
                }
                return server.method_30611();
            };
        }
    }

    @Nullable
    public static class_5455 get() {
        return supplier.get();
    }

    public static class_5455 getOrThrow() {
        class_5455 registryAccess = get();
        if (registryAccess == null) {
            throw new IllegalStateException("Could not get RegistryAccess");
        }
        return registryAccess;
    }
}
