package com.zurrtum.create.infrastructure.items;

import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class CombinedInvWrapper implements class_1278 {
    protected final class_1263[] itemHandler;
    protected final int[] baseIndex;
    private final boolean[] sideInventory;
    protected final int[] slots;

    public CombinedInvWrapper(class_1263... itemHandler) {
        this.itemHandler = itemHandler;
        int length = itemHandler.length;
        this.baseIndex = new int[length];
        this.sideInventory = new boolean[length];
        int index = 0;
        for (int i = 0; i < length; i++) {
            class_1263 inventory = itemHandler[i];
            index += inventory.method_5439();
            baseIndex[i] = index;
            sideInventory[i] = inventory instanceof class_1278;
        }
        this.slots = SlotRangeCache.get(index);
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0)
            return -1;

        for (int i = 0; i < baseIndex.length; i++) {
            if (slot - baseIndex[i] < 0) {
                return i;
            }
        }
        return -1;
    }

    @Nullable
    protected class_1263 getHandlerFromIndex(int index) {
        if (index < 0 || index >= itemHandler.length) {
            return null;
        }
        return itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= baseIndex.length) {
            return slot;
        }
        return slot - baseIndex[index - 1];
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return slots;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        int index = getIndexForSlot(slot);
        class_1263 handler = getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (handler.method_5437(slot, stack)) {
            if (sideInventory[index]) {
                return ((class_1278) handler).method_5492(slot, stack, dir);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        int index = getIndexForSlot(slot);
        class_1263 handler = getHandlerFromIndex(index);
        if (handler == null) {
            return false;
        }
        if (sideInventory[index]) {
            return ((class_1278) handler).method_5493(slot, stack, dir);
        }
        return true;
    }

    @Override
    public int method_5439() {
        return slots.length;
    }

    @Override
    public class_1799 method_5438(int slot) {
        int index = getIndexForSlot(slot);
        class_1263 handler = getHandlerFromIndex(index);
        if (handler == null) {
            return class_1799.field_8037;
        }
        slot = getSlotFromIndex(slot, index);
        return handler.method_5438(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        int index = getIndexForSlot(slot);
        class_1263 handler = getHandlerFromIndex(index);
        if (handler == null) {
            return;
        }
        slot = getSlotFromIndex(slot, index);
        handler.method_5447(slot, stack);
    }

    @Override
    public int insert(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (class_1263 handler : itemHandler) {
            int insert = handler.insert(stack, remaining, side);
            if (remaining == insert) {
                markInventoryDirty();
                return maxAmount;
            }
            if (insert == 0) {
                continue;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        markInventoryDirty();
        return maxAmount - remaining;
    }

    @Override
    public int extract(class_1799 stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (class_1263 handler : itemHandler) {
            int extract = handler.extract(stack, remaining, side);
            if (remaining == extract) {
                markInventoryDirty();
                return maxAmount;
            }
            if (extract == 0) {
                continue;
            }
            remaining -= extract;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        markInventoryDirty();
        return maxAmount - remaining;
    }

    @Override
    public class_1799 extract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = itemHandler.length; i < size; i++) {
            class_1799 findStack = itemHandler[i].extract(predicate, maxAmount, side);
            if (findStack == class_1799.field_8037) {
                continue;
            }
            int extract = findStack.method_7947();
            if (extract == maxAmount) {
                markInventoryDirty();
                return findStack;
            }
            i++;
            if (i == size) {
                markInventoryDirty();
                return findStack;
            }
            int remaining = maxAmount - extract;
            for (; i < size; i++) {
                extract = itemHandler[i].extract(findStack, remaining, side);
                if (remaining == extract) {
                    markInventoryDirty();
                    findStack.method_7939(maxAmount);
                    return findStack;
                }
                if (extract == 0) {
                    continue;
                }
                remaining -= extract;
            }
            markInventoryDirty();
            findStack.method_7939(maxAmount - remaining);
            return findStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return class_1799.field_8037;
        }
        for (int i = 0, size = itemHandler.length; i < size; i++) {
            class_1799 findStack = itemHandler[i].count(predicate, maxAmount, side);
            if (findStack.method_7960()) {
                continue;
            }
            int count = findStack.method_7947();
            if (count == maxAmount) {
                itemHandler[i].extract(findStack, count, side);
                markInventoryDirty();
                return findStack;
            }
            i++;
            if (i == size) {
                break;
            }
            int[] extracts = new int[size];
            extracts[i] = count;
            int remaining = maxAmount - count;
            for (; i < size; i++) {
                int extract = itemHandler[i].count(findStack, remaining, side);
                if (extract == 0) {
                    continue;
                }
                extracts[i] = extract;
                if (remaining > extract) {
                    remaining -= extract;
                    continue;
                }
                for (int j = 0; j <= i; j++) {
                    extract = extracts[j];
                    if (extract == 0) {
                        continue;
                    }
                    itemHandler[j].extract(findStack, extract, side);
                }
                markInventoryDirty();
                findStack.method_7939(maxAmount);
                return findStack;
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public int countAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int count = 0;
        for (class_1263 inventory : itemHandler) {
            count += inventory.countAll(predicate, maxAmount, side);
            if (count >= maxAmount) {
                return maxAmount;
            }
        }
        return count;
    }

    @Override
    public int extractAll(Predicate<class_1799> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return 0;
        }
        int remaining = maxAmount;
        for (class_1263 inventory : itemHandler) {
            int extract = inventory.extractAll(predicate, remaining, side);
            if (extract < remaining) {
                remaining -= extract;
                continue;
            }
            markInventoryDirty();
            return maxAmount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        markInventoryDirty();
        return maxAmount - remaining;
    }

    public void markInventoryDirty() {
    }

    @Override
    public void method_5431() {
        for (class_1263 inventory : itemHandler) {
            inventory.method_5431();
        }
        markInventoryDirty();
    }

    @Override
    @NotNull
    public java.util.Iterator<class_1799> iterator(class_2350 side) {
        if (itemHandler.length == 0) {
            return Collections.emptyIterator();
        } else {
            return new com.zurrtum.create.infrastructure.items.CombinedInvWrapper.Iterator(side);
        }
    }

    class Iterator implements java.util.Iterator<class_1799> {
        private int index;
        private final class_2350 side;
        private java.util.Iterator<class_1799> iterator;

        public Iterator(class_2350 side) {
            this.side = side;
            this.iterator = itemHandler[index].iterator(side);
        }

        @Override
        public boolean hasNext() {
            if (iterator.hasNext()) {
                return true;
            }
            do {
                index++;
                if (index >= itemHandler.length) {
                    return false;
                }
                iterator = itemHandler[index].iterator(side);
            } while (!iterator.hasNext());
            return true;
        }

        @Override
        public class_1799 next() {
            if (hasNext()) {
                return iterator.next();
            } else {
                throw new NoSuchElementException();
            }
        }
    }
}
