package com.zurrtum.create.infrastructure.worldgen;

import com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5867;

public class LayeredOreFeature extends class_3031<LayeredOreConfiguration> {
    public LayeredOreFeature() {
        super(LayeredOreConfiguration.CODEC);
    }

    private static final float MAX_LAYER_DISPLACEMENT = 1.75f;
    private static final float LAYER_NOISE_FREQUENCY = 0.125f;

    private static final float MAX_RADIAL_THRESHOLD_REDUCTION = 0.25f;
    private static final float RADIAL_NOISE_FREQUENCY = 0.125f;

    @Override
    public boolean method_13151(class_5821<LayeredOreConfiguration> pContext) {
        class_5819 random = pContext.method_33654();
        class_2338 origin = pContext.method_33655();
        class_5281 worldGenLevel = pContext.method_33652();
        LayeredOreConfiguration config = pContext.method_33656();
        List<LayerPattern> patternPool = config.layerPatterns;

        if (patternPool.isEmpty())
            return false;

        LayerPattern layerPattern = patternPool.get(random.method_43048(patternPool.size()));

        int placedAmount = 0;
        int size = config.size + 1;
        float radius = config.size * 0.5f;
        int radiusBound = class_3532.method_15386(radius) - 1;
        int x0 = origin.method_10263();
        int y0 = origin.method_10264();
        int z0 = origin.method_10260();

        if (origin.method_10264() >= worldGenLevel.method_8624(class_2902.class_2903.field_13195, origin.method_10263(), origin.method_10260()))
            return false;

        List<TemporaryLayerEntry> tempLayers = new ArrayList<>();
        float layerSizeTotal = 0.0f;
        Layer current = null;
        while (layerSizeTotal < size) {
            Layer next = layerPattern.rollNext(current, random);
            float layerSize = class_3532.method_32751(random, next.minSize, next.maxSize);
            tempLayers.add(new TemporaryLayerEntry(next, layerSize));
            layerSizeTotal += layerSize;
            current = next;
        }

        List<ResolvedLayerEntry> resolvedLayers = new ArrayList<>(tempLayers.size());
        float cumulativeLayerSize = -(layerSizeTotal - size) * random.method_43057();
        for (TemporaryLayerEntry tempLayerEntry : tempLayers) {
            float rampStartValue = resolvedLayers.size() == 0 ? Float.NEGATIVE_INFINITY : cumulativeLayerSize * (2.0f / size) - 1.0f;
            cumulativeLayerSize += tempLayerEntry.size();
            if (cumulativeLayerSize < 0)
                continue;
            float radialThresholdMultiplier = class_3532.method_32750(random, 0.5f, 1.0f);
            resolvedLayers.add(new ResolvedLayerEntry(tempLayerEntry.layer, radialThresholdMultiplier, rampStartValue));
        }

        // Choose stacking direction
        float gy = class_3532.method_32750(random, -1.0f, 1.0f);
        gy = (float) Math.cbrt(gy); // Make layer alignment tend towards horizontal more than vertical
        float xzRescale = class_3532.method_15355(1.0f - gy * gy);
        float theta = random.method_43057() * class_3532.field_29846;
        float gx = class_3532.method_15362(theta) * xzRescale;
        float gz = class_3532.method_15374(theta) * xzRescale;

        class_3541 layerDisplacementNoise = new class_3541(random);
        class_3541 radiusNoise = new class_3541(random);

        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_5867 bulkSectionAccess = new class_5867(worldGenLevel);

        try {

            for (int dzBlock = -radiusBound; dzBlock <= radiusBound; dzBlock++) {
                float dz = dzBlock * (1.0f / radius);
                if (dz * dz > 1)
                    continue;

                for (int dxBlock = -radiusBound; dxBlock <= radiusBound; dxBlock++) {
                    float dx = dxBlock * (1.0f / radius);
                    if (dz * dz + dx * dx > 1)
                        continue;

                    for (int dyBlock = -radiusBound; dyBlock <= radiusBound; dyBlock++) {
                        float dy = dyBlock * (1.0f / radius);
                        float distanceSquared = dz * dz + dx * dx + dy * dy;
                        if (distanceSquared > 1)
                            continue;
                        if (worldGenLevel.method_31601(y0 + dyBlock))
                            continue;

                        int currentX = x0 + dxBlock;
                        int currentY = y0 + dyBlock;
                        int currentZ = z0 + dzBlock;

                        float rampValue = gx * dx + gy * dy + gz * dz;
                        rampValue += layerDisplacementNoise.method_22416(
                            currentX * LAYER_NOISE_FREQUENCY,
                            currentY * LAYER_NOISE_FREQUENCY,
                            currentZ * LAYER_NOISE_FREQUENCY
                        ) * (MAX_LAYER_DISPLACEMENT / size);

                        int layerIndex = Collections.binarySearch(resolvedLayers, new ResolvedLayerEntry(null, 0, rampValue));
                        if (layerIndex < 0)
                            layerIndex = -2 - layerIndex; // Counter (-insertionIndex - 1) return result, where insertionIndex = layerIndex + 1
                        ResolvedLayerEntry layerEntry = resolvedLayers.get(layerIndex);

                        if (distanceSquared > layerEntry.radialThresholdMultiplier)
                            continue;

                        float thresholdNoiseValue = class_3532.method_37959(
                            (float) radiusNoise.method_22416(
                                currentX * RADIAL_NOISE_FREQUENCY,
                                currentY * RADIAL_NOISE_FREQUENCY,
                                currentZ * RADIAL_NOISE_FREQUENCY
                            ),
                            -1.0f,
                            1.0f,
                            1.0f - MAX_RADIAL_THRESHOLD_REDUCTION,
                            1.0f
                        );

                        if (distanceSquared > layerEntry.radialThresholdMultiplier * thresholdNoiseValue)
                            continue;

                        Layer layer = layerEntry.layer;
                        List<class_3124.class_5876> targetBlockStates = layer.rollBlock(random);

                        mutablePos.method_10103(currentX, currentY, currentZ);
                        if (!worldGenLevel.method_37368(mutablePos))
                            continue;
                        class_2826 levelChunkSection = bulkSectionAccess.method_33944(mutablePos);
                        if (levelChunkSection == null)
                            continue;

                        int localX = class_4076.method_18684(currentX);
                        int localY = class_4076.method_18684(currentY);
                        int localZ = class_4076.method_18684(currentZ);
                        class_2680 blockState = levelChunkSection.method_12254(localX, localY, localZ);

                        for (class_3124.class_5876 targetBlockState : targetBlockStates) {
                            if (!canPlaceOre(blockState, bulkSectionAccess::method_33946, random, config, targetBlockState, mutablePos))
                                continue;
                            if (targetBlockState.field_29069.method_26215())
                                continue;
                            levelChunkSection.method_12256(localX, localY, localZ, targetBlockState.field_29069, false);
                            ++placedAmount;
                            break;
                        }

                    }
                }
            }

        } catch (Throwable throwable1) {
            try {
                bulkSectionAccess.close();
            } catch (Throwable throwable) {
                throwable1.addSuppressed(throwable);
            }

            throw throwable1;
        }

        bulkSectionAccess.close();
        return placedAmount > 0;
    }

    public boolean canPlaceOre(
        class_2680 pState,
        Function<class_2338, class_2680> pAdjacentStateAccessor,
        class_5819 pRandom,
        LayeredOreConfiguration pConfig,
        class_3124.class_5876 pTargetState,
        class_2338.class_2339 pMatablePos
    ) {
        if (!pTargetState.field_29068.method_16768(pState, pRandom))
            return false;
        if (shouldSkipAirCheck(pRandom, pConfig.discardChanceOnAirExposure))
            return true;

        return !method_33981(pAdjacentStateAccessor, pMatablePos);
    }

    protected boolean shouldSkipAirCheck(class_5819 pRandom, float pChance) {
        return pChance <= 0 ? true : pChance >= 1 ? false : pRandom.method_43057() >= pChance;
    }

    private record TemporaryLayerEntry(Layer layer, float size) {
    }

    private record ResolvedLayerEntry(Layer layer, float radialThresholdMultiplier, float rampStartValue) implements Comparable<ResolvedLayerEntry> {
        @Override
        public int compareTo(LayeredOreFeature.ResolvedLayerEntry b) {
            return Float.compare(rampStartValue, b.rampStartValue);
        }
    }
}