package com.zurrtum.create.mixin;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1278.class)
public interface SidedInventoryMixin extends SidedItemInventory {
    @Shadow
    int[] getAvailableSlots(class_2350 side);

    @Shadow
    boolean canInsert(int slot, class_1799 stack, @Nullable class_2350 dir);

    @Shadow
    boolean canExtract(int slot, class_1799 stack, class_2350 dir);

    @Override
    default int[] create$getAvailableSlots(class_2350 side) {
        return getAvailableSlots(side);
    }

    @Override
    default boolean create$canInsert(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return canInsert(slot, stack, dir);
    }

    @Override
    default boolean create$canExtract(int slot, class_1799 stack, class_2350 dir) {
        return canExtract(slot, stack, dir);
    }
}
