/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.codecs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Set;

public interface CatnipCodecs {
    public static final PrimitiveCodec<Character> CHAR = new PrimitiveCodec<Character>(){

        public <T> DataResult<Character> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(n -> Character.valueOf((char)n.intValue()));
        }

        public <T> T write(DynamicOps<T> ops, Character value) {
            return (T)ops.createInt((int)value.charValue());
        }

        public String toString() {
            return "Char";
        }
    };

    public static <E> Codec<Set<E>> set(Codec<E> codec) {
        return codec.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }
}

