/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.TextureSheetSegment;
import com.zurrtum.create.client.catnip.gui.render.BreadcrumbArrowRenderState;
import com.zurrtum.create.client.catnip.gui.render.GradientRectRenderState;
import com.zurrtum.create.client.catnip.gui.render.RadialSectorRenderState;
import com.zurrtum.create.client.catnip.gui.render.TexturedQuadRenderState;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10783;
import net.minecraft.class_10799;
import net.minecraft.class_10861;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11286;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class UIRenderHelper {
    private static final class_11286 PROJECTION = new class_11286("UIRenderHelper");
    public static final RenderPipeline BLIT_SCREEN = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation(class_2960.method_60655((String)"create", (String)"pipeline/blit_screen")).withVertexShader("core/blit_screen").withFragmentShader("core/blit_screen").withSampler("InSampler").withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).build();
    public static final Couple<Color> COLOR_TEXT = Couple.create(new Color(-1118482), new Color(-6052957)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_DARKER = Couple.create(new Color(-6052957), new Color(-8355712)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_ACCENT = Couple.create(new Color(-2232577), new Color(-6246208)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_STRONG_ACCENT = Couple.create(new Color(-7686442), new Color(-9530709)).map(Color::setImmutable);
    public static final Color COLOR_STREAK = new Color(0x101010, false).setImmutable();
    @Nullable
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.assertOnRenderThread();
        class_1041 mainWindow = class_310.method_1551().method_22683();
        framebuffer = CustomRenderTarget.create(mainWindow);
    }

    public static void updateWindowSize(class_1041 mainWindow) {
        if (framebuffer != null) {
            framebuffer.method_1234(mainWindow.method_4489(), mainWindow.method_4506());
        }
    }

    public static void drawFramebuffer(class_4587 poseStack, float alpha) {
        if (framebuffer != null) {
            framebuffer.renderWithAlpha(poseStack, alpha);
        }
    }

    public static void swapAndBlitColor(class_276 src, class_276 dst) {
        int srcId = UIRenderHelper.getFrameBufferId(src);
        int dstId = UIRenderHelper.getFrameBufferId(dst);
        GlStateManager._glBindFramebuffer((int)36008, (int)srcId);
        GlStateManager._glBindFramebuffer((int)36009, (int)dstId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)src.field_1480, (int)src.field_1477, (int)0, (int)0, (int)dst.field_1480, (int)dst.field_1477, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36160, (int)dstId);
    }

    private static int getFrameBufferId(class_276 buffer) {
        class_10868 colorAttachment = (class_10868)buffer.method_30277();
        int id = buffer.field_1478 ? ((class_10868)buffer.method_30278()).method_68427() : 0;
        return colorAttachment.field_57885.get(id);
    }

    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length) {
        UIRenderHelper.streak(graphics, angle, x, y, breadth, length, COLOR_STREAK);
    }

    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        Color c1 = color.scaleAlpha(0.625f);
        Color c2 = color.scaleAlpha(0.5f);
        Color c3 = color.scaleAlpha(0.0625f);
        Color c4 = color.scaleAlpha(0.0f);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        poseStack.rotate((float)((double)(angle - 90.0f) * (Math.PI / 180)));
        UIRenderHelper.streak(graphics, breadth / 2, length, c1, c2, c3, c4);
        poseStack.popMatrix();
    }

    private static void streak(class_332 graphics, int width, int height, Color c1, Color c2, Color c3, Color c4) {
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        double split1 = 0.5;
        double split2 = 0.75;
        graphics.method_25296(-width, 0, width, (int)(split1 * (double)height), c1.getRGB(), c2.getRGB());
        graphics.method_25296(-width, (int)(split1 * (double)height), width, (int)(split2 * (double)height), c2.getRGB(), c3.getRGB());
        graphics.method_25296(-width, (int)(split2 * (double)height), width, height, c3.getRGB(), c4.getRGB());
    }

    public static void angledGradient(class_332 graphics, float angle, int x, int y, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, breadth, length, (Color)c.getFirst(), (Color)c.getSecond());
    }

    public static void angledGradient(class_332 graphics, float angle, int x, int y, float breadth, float length, Color startColor, Color endColor) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        poseStack.rotate((float)((double)(angle - 90.0f) * (Math.PI / 180)));
        float w = breadth / 2.0f;
        UIRenderHelper.drawGradientRect(graphics, -w, 0.0f, w, length, startColor, endColor);
        poseStack.popMatrix();
    }

    public static void drawGradientRect(class_332 graphics, float left, float top, float right, float bottom, Color startColor, Color endColor) {
        graphics.field_59826.method_70919((class_11244)new GradientRectRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), left, top, right, bottom, startColor, endColor));
    }

    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Couple<Color> colors) {
        UIRenderHelper.breadcrumbArrow(graphics, x, y, width, height, indent, (Color)colors.getFirst(), (Color)colors.getSecond());
    }

    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Color startColor, Color endColor) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)(x - indent), (float)y);
        UIRenderHelper.breadcrumbArrow(graphics, width, height, indent, startColor, endColor);
        poseStack.popMatrix();
    }

    private static void breadcrumbArrow(class_332 graphics, int width, int height, int indent, Color c1, Color c2) {
        float x0 = 0.0f;
        float x1 = indent;
        float x2 = width;
        float x3 = indent + width;
        float y0 = 0.0f;
        float y1 = (float)height / 2.0f;
        float y2 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0.0f);
        Color fc2 = Color.mixColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        Color fc3 = Color.mixColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        Color fc4 = Color.mixColors(c1, c2, 1.0f);
        graphics.field_59826.method_70919((class_11244)new BreadcrumbArrowRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), x0, x1, x2, x3, y0, y1, y2, fc1, fc2, fc3, fc4, indent + width, height));
    }

    public static void drawRadialSector(class_332 graphics, float innerRadius, float outerRadius, float startAngle, float arcAngle, Color innerColor, Color outerColor) {
        List<Point2D> innerPoints = UIRenderHelper.getPointsForCircleArc(innerRadius, startAngle, arcAngle);
        List<Point2D> outerPoints = UIRenderHelper.getPointsForCircleArc(outerRadius, startAngle, arcAngle);
        graphics.field_59826.method_70919((class_11244)new RadialSectorRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), (int)(innerRadius * 2.0f), (int)(outerRadius * 2.0f), innerPoints, outerPoints, innerColor, outerColor));
    }

    private static List<Point2D> getPointsForCircleArc(float radius, float startAngle, float arcAngle) {
        int segmentCount = Math.abs(arcAngle) <= 90.0f ? 16 : 32;
        ArrayList<Point2D> points = new ArrayList<Point2D>(segmentCount);
        float theta = (float)Math.PI / 180 * arcAngle / (float)(segmentCount - 1);
        float t = (float)Math.PI / 180 * startAngle;
        for (int i = 0; i < segmentCount; ++i) {
            points.add(new Point2D.Float((float)((double)radius * Math.cos(t)), (float)((double)radius * Math.sin(t))));
            t += theta;
        }
        return points;
    }

    public static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, texture, c, x, y, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int x, int y, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, texture, c, x, x + width, y, y + height, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        UIRenderHelper.drawTexturedQuad(graphics, tex.bind(), Color.WHITE, left, left + w, top, top + h, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + tex.getWidth()) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + tex.getHeight()) / 256.0f);
    }

    public static void drawCropped(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        UIRenderHelper.drawTexturedQuad(graphics, tex.bind(), Color.WHITE, left, left + w, top, top + h, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + w) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + h) / 256.0f);
    }

    private static void drawColoredTexture(class_332 graphics, class_11231 texture, Color c, int left, int right, int top, int bot, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics, texture, c, left, right, top, bot, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(class_332 graphics, class_11231 texture, Color c, int left, int right, int top, int bot, float u1, float u2, float v1, float v2) {
        graphics.field_59826.method_70919((class_11244)new TexturedQuadRenderState(new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), texture, left, right, top, bot, c, u1, u2, v1, v2));
    }

    public static void flipForGuiRender(class_4587 poseStack) {
        poseStack.method_34425((Matrix4fc)new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public static class CustomRenderTarget
    extends class_276 {
        public CustomRenderTarget(@Nullable String name, boolean useDepth) {
            super(name, useDepth);
        }

        public static CustomRenderTarget create(class_1041 mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget("Custom", true);
            framebuffer.method_1234(mainWindow.method_4480(), mainWindow.method_4507());
            return framebuffer;
        }

        public void method_1231(int width, int height) {
            class_10865 device = (class_10865)RenderSystem.getDevice();
            int i = device.getMaxTextureSize();
            if (width > 0 && width <= i && height > 0 && height <= i) {
                this.field_1480 = width;
                this.field_1477 = height;
                this.field_1482 = width;
                this.field_1481 = height;
                this.field_1475 = device.createTexture(() -> this.field_56738 + " / Color", 15, TextureFormat.RGBA8, width, height, 1, 1);
                this.field_60567 = device.createTextureView(this.field_1475);
                this.field_1475.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                this.method_1232(FilterMode.NEAREST, true);
                if (this.field_1478) {
                    this.field_56739 = CustomRenderTarget.createDepthTexture(() -> this.field_56738 + " / Depth", 15, TextureFormat.DEPTH32, width, height, 1, 1);
                    this.field_60568 = device.createTextureView(this.field_56739);
                    this.field_56739.setTextureFilter(FilterMode.NEAREST, false);
                    this.field_56739.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                    CustomRenderTarget.setupFramebuffer((class_10868)this.field_1475, ((class_10868)this.field_56739).method_68427());
                }
            } else {
                throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + i + ")");
            }
        }

        private static GpuTexture createDepthTexture(@Nullable Supplier<String> supplier, int usage, TextureFormat textureFormat, int width, int height, int depthOrLayers, int mipLevels) {
            int m;
            String label;
            class_10861 debugLabelManager = ((class_10865)RenderSystem.getDevice()).method_68377();
            String string = label = debugLabelManager.method_68370() && supplier != null ? supplier.get() : null;
            if (mipLevels < 1) {
                throw new IllegalArgumentException("mipLevels must be at least 1");
            }
            GlStateManager.clearGlErrors();
            int glId = GlStateManager._genTexture();
            if (label == null) {
                label = String.valueOf(glId);
            }
            GlStateManager._bindTexture((int)glId);
            GlStateManager._texParameter((int)3553, (int)33085, (int)(mipLevels - 1));
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)(mipLevels - 1));
            if (textureFormat.hasDepthAspect()) {
                GlStateManager._texParameter((int)3553, (int)34892, (int)0);
            }
            for (m = 0; m < mipLevels; ++m) {
                GlStateManager._texImage2D((int)3553, (int)m, (int)36013, (int)(width >> m), (int)(height >> m), (int)0, (int)34041, (int)36269, null);
            }
            m = GlStateManager._getError();
            if (m == 1285) {
                throw new class_10783("Could not allocate texture of " + width + "x" + height + " for " + label);
            }
            if (m != 0) {
                throw new IllegalStateException("OpenGL error " + m);
            }
            class_10868 glTexture = new class_10868(usage, label, textureFormat, width, height, depthOrLayers, mipLevels, glId);
            debugLabelManager.method_68374(glTexture);
            return glTexture;
        }

        private static void setupFramebuffer(class_10868 colorAttachment, int depthAttachmentId) {
            int framebufferId = GlStateManager.glGenFramebuffers();
            int target = 36009;
            int fbo = GlStateManager.getFrameBuffer((int)target);
            GlStateManager._glBindFramebuffer((int)target, (int)framebufferId);
            GlStateManager._glFramebufferTexture2D((int)target, (int)36064, (int)3553, (int)colorAttachment.method_68427(), (int)0);
            GlStateManager._glFramebufferTexture2D((int)target, (int)36096, (int)3553, (int)depthAttachmentId, (int)0);
            GlStateManager._glFramebufferTexture2D((int)target, (int)36128, (int)3553, (int)depthAttachmentId, (int)0);
            GlStateManager._glBindFramebuffer((int)target, (int)fbo);
            colorAttachment.field_57885.put(depthAttachmentId, framebufferId);
        }

        public void renderWithAlpha(class_4587 poseStack, float alpha) {
            class_1041 window = class_310.method_1551().method_22683();
            float guiScaledWidth = window.method_4486();
            float guiScaledHeight = window.method_4502();
            float vx = guiScaledWidth;
            float vy = guiScaledHeight;
            float tx = (float)this.field_1480 / (float)this.field_1482;
            float ty = (float)this.field_1477 / (float)this.field_1481;
            class_310 minecraft = class_310.method_1551();
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)PROJECTION.method_71123(matrix4f), (class_10366)class_10366.field_54954);
            GpuBufferSlice dynamicTransformsBuffer = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)new Matrix4f().setTranslation(0.0f, 0.0f, -2000.0f), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
            VertexFormat.class_5596 vertexFormatMode = BLIT_SCREEN.getVertexFormatMode();
            VertexFormat vertexFormat = BLIT_SCREEN.getVertexFormat();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_60827(vertexFormatMode, vertexFormat);
            bufferbuilder.method_22912(0.0f, vy, 0.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.method_22912(vx, vy, 0.0f).method_22913(tx, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.method_22912(vx, 0.0f, 0.0f).method_22913(tx, ty).method_22915(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.method_22912(0.0f, 0.0f, 0.0f).method_22913(0.0f, ty).method_22915(1.0f, 1.0f, 1.0f, alpha);
            class_9801 buffer = bufferbuilder.method_60800();
            class_276 framebuffer = minecraft.method_1522();
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
            GpuBuffer gpuBuffer = vertexFormat.uploadImmediateVertexBuffer(buffer.method_60818());
            int count = buffer.method_60822().comp_751();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Immediate draw for UIRenderHelper", framebuffer.method_71639(), OptionalInt.empty(), framebuffer.method_71640(), OptionalDouble.empty());){
                renderPass.setPipeline(BLIT_SCREEN);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setVertexBuffer(0, shapeIndexBuffer.method_68274(count));
                renderPass.setIndexBuffer(gpuBuffer, shapeIndexBuffer.method_31924());
                renderPass.bindSampler("InSampler", this.field_60567);
                renderPass.setUniform("DynamicTransforms", dynamicTransformsBuffer);
                renderPass.drawIndexed(0, 0, count, 1);
            }
            buffer.close();
            RenderSystem.restoreProjectionMatrix();
        }
    }
}

