/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.element;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.render.BoxRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11244;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class BoxElement
extends AbstractRenderElement {
    public static final Couple<Color> COLOR_VANILLA_BORDER = Couple.create(new Color(0x505000FF, true), new Color(1344798847, true)).map(Color::setImmutable);
    public static final Color COLOR_VANILLA_BACKGROUND = new Color(-267386864, true).setImmutable();
    public static final Color COLOR_BACKGROUND_FLAT = new Color(-16777216, true).setImmutable();
    public static final Color COLOR_BACKGROUND_TRANSPARENT = new Color(-587202560, true).setImmutable();
    protected Color background = COLOR_VANILLA_BACKGROUND;
    protected Color borderTop = (Color)COLOR_VANILLA_BORDER.getFirst();
    protected Color borderBot = (Color)COLOR_VANILLA_BORDER.getSecond();
    protected int borderOffset = 2;

    public <T extends BoxElement> T withBackground(Color color) {
        this.background = color;
        return (T)this;
    }

    public <T extends BoxElement> T withBackground(int color) {
        return this.withBackground(new Color(color, true));
    }

    public <T extends BoxElement> T flatBorder(Color color) {
        this.borderTop = color;
        this.borderBot = color;
        return (T)this;
    }

    public <T extends BoxElement> T flatBorder(int color) {
        return this.flatBorder(new Color(color, true));
    }

    public <T extends BoxElement> T gradientBorder(Couple<Color> colors) {
        this.borderTop = (Color)colors.getFirst();
        this.borderBot = (Color)colors.getSecond();
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(Color top, Color bot) {
        this.borderTop = top;
        this.borderBot = bot;
        return (T)this;
    }

    public <T extends BoxElement> T gradientBorder(int top, int bot) {
        return this.gradientBorder(new Color(top, true), new Color(bot, true));
    }

    public <T extends BoxElement> T withBorderOffset(int offset) {
        this.borderOffset = offset;
        return (T)this;
    }

    @Override
    public void render(class_332 graphics) {
        this.renderBox(graphics);
    }

    protected void renderBox(class_332 graphics) {
        Color c1 = this.background.copy().scaleAlpha(this.alpha);
        Color c2 = this.borderTop.copy().scaleAlpha(this.alpha);
        Color c3 = this.borderBot.copy().scaleAlpha(this.alpha);
        Matrix3x2f model = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        graphics.field_59826.method_70919((class_11244)new BoxRenderState(model, this.x, this.y, this.width, this.height, this.borderOffset, c1, c2, c3));
    }
}

