/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.placement;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.client.catnip.ghostblock.GhostBlocks;
import com.zurrtum.create.client.catnip.gui.render.ArrowRenderState;
import com.zurrtum.create.client.catnip.gui.render.TextureArrowRenderState;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.ponder.config.CClient;
import com.zurrtum.create.client.ponder.enums.PonderConfig;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class PlacementClient {
    static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    @Nullable
    static class_2338 target = null;
    @Nullable
    static class_2338 lastTarget = null;
    static int animationTick = 0;

    public static void tick(class_310 mc) {
        PlacementClient.setTarget(null);
        PlacementClient.checkHelpers(mc);
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static void checkHelpers(class_310 mc) {
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        class_1268[] class_1268Array = mc.field_1765;
        if (!(class_1268Array instanceof class_3965)) {
            return;
        }
        class_3965 ray = (class_3965)class_1268Array;
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.field_1724.method_5715()) {
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 heldItem = mc.field_1724.method_5998(hand);
            ArrayList<IPlacementHelper> filteredForHeldItem = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : PlacementHelpers.getHelpersView()) {
                if (!helper.matchesItem(heldItem)) continue;
                filteredForHeldItem.add(helper);
            }
            if (filteredForHeldItem.isEmpty()) continue;
            class_2338 pos = ray.method_17777();
            class_2680 state = world.method_8320(pos);
            ArrayList<IPlacementHelper> filteredForState = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : filteredForHeldItem) {
                if (!helper.matchesState(state)) continue;
                filteredForState.add(helper);
            }
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((class_1657)mc.field_1724, (class_1937)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                PlacementClient.renderAt(h, offset);
                PlacementClient.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(@Nullable class_2338 target) {
        PlacementClient.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    public static void onRenderCrosshairOverlay(class_310 mc, class_332 graphics, float partialTicks) {
        class_746 player = mc.field_1724;
        if (player != null && animationTick > 0) {
            float screenY = (float)graphics.method_51443() / 2.0f;
            float screenX = (float)graphics.method_51421() / 2.0f;
            float progress = PlacementClient.getCurrentAlpha();
            PlacementClient.drawDirectionIndicator(graphics, partialTicks, screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    private static void drawDirectionIndicator(class_332 graphics, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        class_243 projTarget = com.zurrtum.create.client.catnip.math.VecHelper.projectToPlayerView(VecHelper.getCenterOf((class_2382)lastTarget), partialTicks);
        class_243 target = new class_243(projTarget.field_1352, projTarget.field_1351, 0.0);
        if (projTarget.field_1350 > 0.0) {
            target = target.method_22882();
        }
        class_243 norm = target.method_1029();
        class_243 ref = new class_243(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(-Math.acos(norm.method_1026(ref)));
        if (norm.field_1352 < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)PonderConfig.client().placementIndicator.get());
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementClient.fadedArrow(graphics, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementClient.textured(graphics, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(class_332 graphics, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate(centerX, centerY);
        ms.rotate(angle.getValue(0.0f) * ((float)Math.PI / 180));
        double scale = ((Float)PonderConfig.client().indicatorScale.get()).floatValue();
        ms.scale((float)scale, (float)scale);
        int size = (int)((double)(10.0f + length) * scale);
        graphics.field_59826.method_70919((class_11244)new ArrowRenderState(new Matrix3x2f((Matrix3x2fc)ms), size, r, g, b, a, length));
        ms.popMatrix();
    }

    public static void textured(class_332 graphics, float centerX, float centerY, float alpha, float snappedAngle) {
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate(centerX, centerY);
        float scale = ((Float)PonderConfig.client().indicatorScale.get()).floatValue() * 0.75f;
        ms.scale(scale, scale);
        ms.scale(12.0f, 12.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        int size = (int)(36.0f * scale);
        class_11231 texture = PonderGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        graphics.field_59826.method_70919((class_11244)new TextureArrowRenderState(new Matrix3x2f((Matrix3x2fc)ms), size, alpha, texture, tx, ty, tw, th));
        ms.popMatrix();
    }

    public static void renderAt(Object slot, PlacementOffset offset) {
        PlacementClient.displayGhost(slot, offset);
    }

    public static void renderArrow(class_243 center, class_243 target, class_2350 arrowPlane) {
        PlacementClient.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(class_243 center, class_243 target, class_2350 arrowPlane, double distanceFromCenter) {
        class_243 direction = target.method_1020(center).method_1029();
        class_243 facing = class_243.method_24954((class_2382)arrowPlane.method_62675());
        class_243 start = center.method_1019(direction);
        class_243 offset = direction.method_1021(distanceFromCenter - 1.0);
        class_243 offsetA = direction.method_1036(facing).method_1029().method_1021(0.25);
        class_243 offsetB = facing.method_1036(direction).method_1029().method_1021(0.25);
        class_243 endA = center.method_1019(direction.method_1021(0.75)).method_1019(offsetA);
        class_243 endB = center.method_1019(direction.method_1021(0.75)).method_1019(offsetB);
        Outliner.getInstance().showLine("placementArrowA" + String.valueOf(center) + String.valueOf(target), start.method_1019(offset), endA.method_1019(offset)).lineWidth(0.0625f);
        Outliner.getInstance().showLine("placementArrowB" + String.valueOf(center) + String.valueOf(target), start.method_1019(offset), endB.method_1019(offset)).lineWidth(0.0625f);
    }

    public static void displayGhost(Object slot, PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        GhostBlocks.getInstance().showGhostState(slot, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }
}

