/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.content.equipment.toolbox.ToolboxHandlerClient;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class RadialToolboxMenu
extends AbstractSimiScreen {
    private State state;
    private int ticksOpen;
    private int hoveredSlot;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private final List<ToolboxBlockEntity> toolboxes;
    private ToolboxBlockEntity selectedBox;
    private static final int DEPOSIT = -7;
    private static final int UNEQUIP = -5;

    public RadialToolboxMenu(List<ToolboxBlockEntity> toolboxes, State state, @Nullable ToolboxBlockEntity selectedBox) {
        this.toolboxes = toolboxes;
        this.state = state;
        this.hoveredSlot = -1;
        if (selectedBox != null) {
            this.selectedBox = selectedBox;
        }
    }

    public void prevSlot(int slot) {
        this.scrollSlot = slot;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean renderCenterSlot;
        float hoveredY;
        float fade = class_3532.method_15363((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        this.hoveredSlot = -1;
        class_1041 window = this.field_22787.method_22683();
        float hoveredX = mouseX - window.method_4486() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.method_4502() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = class_3532.method_15375((float)(AngleHelper.deg(class_3532.method_15349((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        boolean bl = renderCenterSlot = this.state == State.SELECT_ITEM_UNEQUIP;
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        if (renderCenterSlot && distance <= 150.0f) {
            this.hoveredSlot = -5;
        }
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate((float)(this.field_22789 / 2), (float)(this.field_22790 / 2));
        class_5250 tip = null;
        if (this.state == State.DETACH) {
            tip = CreateLang.translateDirect("toolbox.outOfRange", new Object[0]);
            if (hoveredX > -20.0f && hoveredX < 20.0f && hoveredY > -80.0f && hoveredY < -20.0f) {
                this.hoveredSlot = -5;
            }
            ms.pushMatrix();
            AllGuiTextures.TOOLBELT_INACTIVE_SLOT.render(graphics, -12, -12);
            graphics.method_51427(AllItems.BROWN_TOOLBOX.method_7854(), -9, -9);
            ms.translate(0.0f, -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade));
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5f, 0.5f);
            AllIcons.I_DISABLE.render(graphics, -9, -9);
            ms.translate(0.5f, -0.5f);
            if (!this.scrollMode && this.hoveredSlot == -5) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect("toolbox.detach", new Object[0]).method_27692(class_124.field_1065);
            }
            ms.popMatrix();
        } else {
            if (hoveredX > 60.0f && hoveredX < 100.0f && hoveredY > -20.0f && hoveredY < 20.0f) {
                this.hoveredSlot = -7;
            }
            ms.pushMatrix();
            ms.translate(80.0f + -5.0f * (1.0f - fade) * (1.0f - fade), 0.0f);
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5f, 0.5f);
            AllIcons.I_TOOLBOX.render(graphics, -9, -9);
            ms.translate(0.5f, -0.5f);
            if (!this.scrollMode && this.hoveredSlot == -7) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect(this.state == State.SELECT_BOX ? "toolbox.depositAll" : "toolbox.depositBox", new Object[0]).method_27692(class_124.field_1065);
            }
            ms.popMatrix();
            for (int slot = 0; slot < 8; ++slot) {
                ms.pushMatrix();
                ms.rotate((float)Math.PI / 180 * (float)(slot * 45 - 45));
                ms.translate(0.0f, -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade));
                ms.rotate((float)Math.PI / 180 * (float)(-slot * 45 + 45));
                ms.translate(-12.0f, -12.0f);
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    class_1799 stackInSlot = (class_1799)inv.filters.get(slot);
                    if (!stackInSlot.method_7960()) {
                        boolean empty = inv.method_5438(slot * 4).method_7960();
                        (empty ? AllGuiTextures.TOOLBELT_INACTIVE_SLOT : AllGuiTextures.TOOLBELT_SLOT).render(graphics, 0, 0);
                        graphics.method_51427(stackInSlot, 3, 3);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot) && !empty) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = stackInSlot.method_7964();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
                    }
                } else if (this.state == State.SELECT_BOX) {
                    if (slot < this.toolboxes.size()) {
                        AllGuiTextures.TOOLBELT_SLOT.render(graphics, 0, 0);
                        ToolboxBlockEntity toolboxBlockEntity = this.toolboxes.get(slot);
                        class_1799 stack = toolboxBlockEntity.method_11010().method_26204().method_8389().method_7854();
                        graphics.method_51427(stack, 3, 3);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot)) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = toolboxBlockEntity.method_5476();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
                    }
                }
                ms.popMatrix();
            }
            if (renderCenterSlot) {
                ms.pushMatrix();
                AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
                (this.scrollMode ? AllIcons.I_REFRESH : AllIcons.I_FLIP).render(graphics, -9, -9);
                if (!this.scrollMode && -5 == this.hoveredSlot) {
                    AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                    tip = CreateLang.translateDirect("toolbox.unequip", this.field_22787.field_1724.method_6047().method_7964()).method_27692(class_124.field_1065);
                }
                ms.popMatrix();
            }
        }
        ms.popMatrix();
        if (tip != null) {
            int i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.pushMatrix();
                ms.translate((float)(this.field_22789 / 2), (float)(this.field_22790 - 68));
                int k1 = 0xFFFFFF;
                int k = i1 << 24 & 0xFF000000;
                int l = this.field_22793.method_27525((class_5348)tip);
                graphics.method_51439(this.field_22793, (class_2561)tip, Math.round((float)(-l) / 2.0f), -4, k1 | k, false);
                ms.popMatrix();
            }
        }
    }

    public void method_25420(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f));
        pGuiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, color.getRGB(), color.getRGB());
    }

    @Override
    public void method_25393() {
        ++this.ticksOpen;
        super.method_25393();
    }

    public void method_25432() {
        int selected;
        super.method_25432();
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (selected == -7) {
            if (this.state == State.DETACH) {
                return;
            }
            if (this.state == State.SELECT_BOX) {
                this.toolboxes.forEach(be -> this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxDisposeAllPacket(be.method_11016())));
            } else {
                this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxDisposeAllPacket(this.selectedBox.method_11016()));
            }
            return;
        }
        if (this.state == State.SELECT_BOX) {
            return;
        }
        if (this.state == State.DETACH) {
            if (selected == -5) {
                this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxEquipPacket(null, selected, this.field_22787.field_1724.method_31548().method_67532()));
            }
            return;
        }
        if (selected == -5) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxEquipPacket(this.selectedBox.method_11016(), selected, this.field_22787.field_1724.method_31548().method_67532()));
        }
        if (selected < 0) {
            return;
        }
        ToolboxInventory inv = this.selectedBox.inventory;
        class_1799 stackInSlot = (class_1799)inv.filters.get(selected);
        if (stackInSlot.method_7960()) {
            return;
        }
        if (inv.method_5438(selected * 4).method_7960()) {
            return;
        }
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxEquipPacket(this.selectedBox.method_11016(), selected, this.field_22787.field_1724.method_31548().method_67532()));
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        double hoveredY;
        class_1041 window = this.field_22787.method_22683();
        double hoveredX = pMouseY - (double)(window.method_4486() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = pMouseY - (double)(window.method_4502() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            this.scrollSlot = ((int)((double)this.scrollSlot - pScrollY) + 8) % 8;
            for (int i = 0; i < 10; ++i) {
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    class_1799 stackInSlot = (class_1799)inv.filters.get(this.scrollSlot);
                    if (!stackInSlot.method_7960() && !inv.method_5438(this.scrollSlot * 4).method_7960()) break;
                }
                if (this.state == State.SELECT_BOX && this.scrollSlot < this.toolboxes.size() || this.state == State.DETACH) break;
                this.scrollSlot -= class_3532.method_17822((double)pScrollY);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public boolean method_25402(double x, double y, int button) {
        int selected;
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (button == 0) {
            if (selected == -7) {
                this.method_25419();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
            if (this.state == State.SELECT_BOX && selected >= 0 && selected < this.toolboxes.size()) {
                this.state = State.SELECT_ITEM;
                this.selectedBox = this.toolboxes.get(selected);
                return true;
            }
            if (!(this.state != State.DETACH && this.state != State.SELECT_ITEM && this.state != State.SELECT_ITEM_UNEQUIP || selected != -5 && selected < 0)) {
                this.method_25419();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        if (button == 1) {
            if (this.state == State.SELECT_ITEM && this.toolboxes.size() > 1) {
                this.state = State.SELECT_BOX;
                return true;
            }
            if (this.state == State.SELECT_ITEM_UNEQUIP && selected == -5) {
                if (this.toolboxes.size() > 1) {
                    this.field_22787.field_1724.field_3944.method_52787((class_2596)new ToolboxEquipPacket(this.selectedBox.method_11016(), selected, this.field_22787.field_1724.method_31548().method_67532()));
                    this.state = State.SELECT_BOX;
                    return true;
                }
                this.method_25419();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        return super.method_25402(x, y, button);
    }

    @Override
    public boolean method_25404(int code, int scanCode, int modifiers) {
        class_304[] hotbarBinds = this.field_22787.field_1690.field_1852;
        for (int i = 0; i < hotbarBinds.length && i < 8; ++i) {
            if (!hotbarBinds[i].method_1417(code, scanCode)) continue;
            if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                ToolboxInventory inv = this.selectedBox.inventory;
                class_1799 stackInSlot = (class_1799)inv.filters.get(i);
                if (stackInSlot.method_7960() || inv.method_5438(i * 4).method_7960()) {
                    return false;
                }
            }
            if (this.state == State.SELECT_BOX && i >= this.toolboxes.size()) {
                return false;
            }
            this.scrollMode = true;
            this.scrollSlot = i;
            this.method_25402(0.0, 0.0, 0);
            return true;
        }
        return super.method_25404(code, scanCode, modifiers);
    }

    public boolean method_16803(int code, int scanCode, int modifiers) {
        class_3675.class_306 mouseKey = class_3675.method_15985((int)code, (int)scanCode);
        if (mouseKey == AllKeys.TOOLBELT.field_1655) {
            this.method_25419();
            return true;
        }
        return super.method_16803(code, scanCode, modifiers);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum State {
        SELECT_BOX,
        SELECT_ITEM,
        SELECT_ITEM_UNEQUIP,
        DETACH;

    }
}

