/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.content.equipment.toolbox.RadialToolboxMenu;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ToolboxHandlerClient {
    static int COOLDOWN = 0;

    public static void clientTick() {
        if (!(COOLDOWN <= 0 || AllKeys.TOOLBELT.method_1436() || AllKeys.TOOLBELT.field_1655 == AllKeys.TOOL_MENU.field_1655 && AllKeys.TOOL_MENU.method_1436())) {
            --COOLDOWN;
        }
    }

    public static boolean onPickItem(class_310 mc) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_239 hitResult = mc.field_1765;
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return false;
        }
        if (player.method_68878()) {
            return false;
        }
        class_1799 result = class_1799.field_8037;
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((class_1936)player.method_37908(), (class_1657)player, 8);
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hitResult).method_17777();
            class_2680 state = level.method_8320(pos);
            if (state.method_26215()) {
                return false;
            }
            result = state.method_65171((class_4538)level, pos, true);
        } else if (hitResult.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)hitResult).method_17782();
            result = entity.method_31480();
        }
        if (result.method_7960()) {
            return false;
        }
        for (ToolboxBlockEntity toolboxBlockEntity : toolboxes) {
            ToolboxInventory inventory = toolboxBlockEntity.inventory;
            for (int comp = 0; comp < 8; ++comp) {
                class_1799 inSlot = inventory.takeFromCompartment(1, comp, true);
                if (inSlot.method_7960() || inSlot.method_7909() != result.method_7909() || !class_1799.method_7973((class_1799)inSlot, (class_1799)result)) continue;
                player.field_3944.method_52787((class_2596)new ToolboxEquipPacket(toolboxBlockEntity.method_11016(), comp, player.method_31548().method_67532()));
                return true;
            }
        }
        return false;
    }

    public static boolean onKeyInput(class_310 mc, class_3675.class_306 key) {
        if (key != AllKeys.TOOLBELT.field_1655) {
            return false;
        }
        if (mc.field_1761 == null || mc.field_1761.method_2920() == class_1934.field_9219) {
            return false;
        }
        if (COOLDOWN > 0) {
            return false;
        }
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        class_1937 level = player.method_37908();
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((class_1936)player.method_37908(), (class_1657)player, 8);
        toolboxes.sort(Comparator.comparing(ToolboxBlockEntity::getUniqueId));
        class_2487 compound = AllSynchedDatas.TOOLBOX.get((class_1297)player);
        String slotKey = String.valueOf(player.method_31548().method_67532());
        boolean equipped = compound.method_10545(slotKey);
        if (equipped) {
            class_2586 blockEntity;
            boolean canReachToolbox;
            class_2487 slotCompound = compound.method_68568(slotKey);
            class_2338 pos = slotCompound.method_67491("Pos", class_2338.field_25064).orElse(class_2338.field_10980);
            double max = ToolboxHandler.getMaxRange((class_1657)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance(player.method_19538(), pos) < max * max;
            if (canReachToolbox && (blockEntity = level.method_8321(pos)) instanceof ToolboxBlockEntity) {
                RadialToolboxMenu screen = new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, (ToolboxBlockEntity)blockEntity);
                screen.prevSlot(slotCompound.method_68083("Slot", 0));
                ScreenOpener.open(screen);
                return true;
            }
            ScreenOpener.open(new RadialToolboxMenu((List<ToolboxBlockEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
            return true;
        }
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (toolboxes.size() == 1) {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM, toolboxes.getFirst()));
        } else {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_BOX, null));
        }
        return true;
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics) {
        int width = guiGraphics.method_51421();
        int height = guiGraphics.method_51443();
        int x = width / 2 - 90;
        int y = height - 23;
        class_746 player = mc.field_1724;
        class_2487 compound = AllSynchedDatas.TOOLBOX.get((class_1297)player);
        if (compound.method_33133()) {
            return;
        }
        int selectedSlot = player.method_31548().method_67532();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.method_10545(key)) continue;
            class_2338 pos = compound.method_68568(key).method_67491("Pos", class_2338.field_25064).orElse(class_2338.field_10980);
            double max = ToolboxHandler.getMaxRange((class_1657)player);
            boolean selected = slot == selectedSlot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance(player.method_19538(), pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.render(guiGraphics, x + 20 * slot - offset, y + offset);
        }
    }
}

