/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrainIcons;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.zurrtum.create.client.content.trains.entity.TrainIcon;
import com.zurrtum.create.client.content.trains.station.AbstractStationScreen;
import com.zurrtum.create.client.content.trains.station.AssemblyScreen;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.content.trains.station.WideIconButton;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class StationScreen
extends AbstractStationScreen {
    private class_342 nameBox;
    private class_342 trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;
    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private DoorControl doorControl;
    private ScrollInput colorTypeScroll;
    private int messedWithColors;
    private boolean switchingToAssemblyMode;

    public StationScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION;
        this.leavingAnimation = 0;
        this.trainPosition = LerpedFloat.linear().startWithValue(0.0);
        this.switchingToAssemblyMode = false;
        this.doorControl = be.doorControls.mode;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        Consumer<String> onTextChanged = s -> this.nameBox.method_46421(this.nameBoxX((String)s, this.nameBox));
        this.nameBox = new class_342((class_327)new NoShadowFontWrapper(this.field_22793), x + 23, y + 4, this.background.getWidth() - 20, 10, (class_2561)class_2561.method_43470((String)this.station.name));
        this.nameBox.method_1858(false);
        this.nameBox.method_1880(25);
        this.nameBox.method_1868(-10935260);
        this.nameBox.method_1852(this.station.name);
        this.nameBox.method_25365(false);
        this.nameBox.method_25402(0.0, 0.0, 0);
        this.nameBox.method_1863(onTextChanged);
        this.nameBox.method_46421(this.nameBoxX(this.nameBox.method_1882(), this.nameBox));
        this.method_37063((class_364)this.nameBox);
        Runnable assemblyCallback = () -> {
            this.switchingToAssemblyMode = true;
            this.field_22787.method_1507((class_437)new AssemblyScreen(this.blockEntity, this.station));
        };
        this.newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        this.newTrainButton.withCallback(assemblyCallback);
        this.method_37063(this.newTrainButton);
        this.disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        this.disassembleTrainButton.field_22763 = false;
        this.disassembleTrainButton.field_22764 = false;
        this.disassembleTrainButton.withCallback(assemblyCallback);
        this.method_37063(this.disassembleTrainButton);
        this.dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        this.dropScheduleButton.field_22763 = false;
        this.dropScheduleButton.field_22764 = false;
        this.dropScheduleButton.withCallback(() -> this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.dropSchedule(this.blockEntity.method_11016())));
        this.method_37063(this.dropScheduleButton);
        this.colorTypeScroll = new ScrollInput(x + 166, y + 17, 22, 14).titled(CreateLang.translateDirect("station.train_map_color", new Object[0]));
        this.colorTypeScroll.withRange(0, 16);
        this.colorTypeScroll.withStepFunction(ctx -> this.colorTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx));
        this.colorTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.mapColorIndex = s;
                this.messedWithColors = 10;
            }
        });
        this.colorTypeScroll.field_22764 = false;
        this.colorTypeScroll.field_22763 = false;
        this.method_37063(this.colorTypeScroll);
        onTextChanged = s -> this.trainNameBox.method_46421(this.nameBoxX((String)s, this.trainNameBox));
        this.trainNameBox = new class_342(this.field_22793, x + 23, y + 47, this.background.getWidth() - 75, 10, class_5244.field_39003);
        this.trainNameBox.method_1858(false);
        this.trainNameBox.method_1880(35);
        this.trainNameBox.method_1868(-3750202);
        this.trainNameBox.method_25365(false);
        this.trainNameBox.method_25402(0.0, 0.0, 0);
        this.trainNameBox.method_1863(onTextChanged);
        this.trainNameBox.field_22763 = false;
        this.tickTrainDisplay();
        Pair<ScrollInput, Label> doorControlWidgets = SlidingDoorRenderer.createWidget(this.field_22787, x + 35, y + 102, mode -> {
            this.doorControl = mode;
        }, this.doorControl);
        this.method_37063(doorControlWidgets.getFirst());
        this.method_37063(doorControlWidgets.getSecond());
    }

    @Override
    public void method_25393() {
        this.tickTrainDisplay();
        if (this.method_25399() != this.nameBox) {
            this.nameBox.method_1875(this.nameBox.method_1882().length());
            this.nameBox.method_1884(this.nameBox.method_1881());
        }
        if (this.method_25399() != this.trainNameBox || !this.trainNameBox.field_22763) {
            this.trainNameBox.method_1875(this.trainNameBox.method_1882().length());
            this.trainNameBox.method_1884(this.trainNameBox.method_1881());
        }
        if (this.messedWithColors > 0) {
            --this.messedWithColors;
            if (this.messedWithColors == 0) {
                this.syncTrainNameAndColor();
            }
        }
        super.method_25393();
        this.updateAssemblyTooltip(this.blockEntity.edgePoint.isOnCurve() ? "no_assembly_curve" : (!this.blockEntity.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : (this.trainPresent() && !this.blockEntity.trainCanDisassemble ? "train_not_aligned" : null)));
    }

    private void tickTrainDisplay() {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            if (this.trainNameBox.field_22763) {
                this.trainNameBox.field_22763 = false;
                this.method_37066((class_364)this.trainNameBox);
            }
            this.leavingAnimation = 0;
            this.newTrainButton.field_22763 = this.blockEntity.edgePoint.isOrthogonal();
            this.newTrainButton.field_22764 = true;
            this.colorTypeScroll.field_22764 = false;
            this.colorTypeScroll.field_22763 = false;
            Train imminentTrain = this.getImminent();
            if (imminentTrain != null) {
                this.displayedTrain = new WeakReference<Train>(imminentTrain);
                this.newTrainButton.field_22763 = false;
                this.newTrainButton.field_22764 = false;
                this.disassembleTrainButton.field_22763 = false;
                this.disassembleTrainButton.field_22764 = true;
                this.dropScheduleButton.field_22763 = this.blockEntity.trainHasSchedule;
                this.dropScheduleButton.field_22764 = true;
                if (this.mapModsPresent()) {
                    this.colorTypeScroll.setState(imminentTrain.mapColorIndex);
                    this.colorTypeScroll.field_22764 = true;
                    this.colorTypeScroll.field_22763 = true;
                }
                this.trainNameBox.field_22763 = true;
                this.trainNameBox.method_1852(imminentTrain.name.getString());
                this.trainNameBox.method_46421(this.nameBoxX(this.trainNameBox.method_1882(), this.trainNameBox));
                this.method_37063((class_364)this.trainNameBox);
                int trainIconWidth = this.getTrainIconWidth(imminentTrain);
                int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130) {
                    targetPos -= trainIconWidth - 130;
                }
                float f = (float)(imminentTrain.navigation.distanceToDestination / 15.0);
                if (this.trainPresent()) {
                    f = 0.0f;
                }
                this.trainPosition.startWithValue((float)targetPos - (float)(targetPos + 5) * f);
            }
            return;
        }
        int trainIconWidth = this.getTrainIconWidth(train);
        int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130) {
            targetPos -= trainIconWidth - 130;
        }
        if (this.leavingAnimation > 0) {
            this.colorTypeScroll.field_22764 = false;
            this.colorTypeScroll.field_22763 = false;
            this.disassembleTrainButton.field_22763 = false;
            float f = 1.0f - (float)this.leavingAnimation / 80.0f;
            this.trainPosition.setValue((float)targetPos + f * f * f * (float)(this.background.getWidth() - targetPos + 5));
            --this.leavingAnimation;
            if (this.leavingAnimation > 0) {
                return;
            }
            this.displayedTrain = new WeakReference<Object>(null);
            this.disassembleTrainButton.field_22764 = false;
            this.dropScheduleButton.field_22763 = false;
            this.dropScheduleButton.field_22764 = false;
            return;
        }
        if (this.getImminent() != train) {
            this.leavingAnimation = 80;
            return;
        }
        boolean trainAtStation = this.trainPresent();
        this.disassembleTrainButton.field_22763 = trainAtStation && this.blockEntity.trainCanDisassemble && this.blockEntity.edgePoint.isOrthogonal();
        this.dropScheduleButton.field_22763 = this.blockEntity.trainHasSchedule;
        if (this.blockEntity.trainHasSchedule) {
            this.dropScheduleButton.setToolTip((class_2561)CreateLang.translateDirect(this.blockEntity.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule", new Object[0]));
        } else {
            this.dropScheduleButton.getToolTip().clear();
        }
        float f = trainAtStation ? 0.0f : (float)(train.navigation.distanceToDestination / 30.0);
        this.trainPosition.setValue((float)targetPos - (float)(targetPos + trainIconWidth) * f);
    }

    private int nameBoxX(String s, class_342 nameBox) {
        return this.guiLeft + this.background.getWidth() / 2 - (Math.min(this.field_22793.method_1727(s), nameBox.method_25368()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            this.disassembleTrainButton.setToolTip((class_2561)CreateLang.translateDirect("station.disassemble_train", new Object[0]));
            this.newTrainButton.setToolTip((class_2561)CreateLang.translateDirect("station.create_train", new Object[0]));
            return;
        }
        for (IconButton ib : new IconButton[]{this.disassembleTrainButton, this.newTrainButton}) {
            List<class_2561> toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add((class_2561)CreateLang.translateDirect("station." + key, new Object[0]).method_27692(class_124.field_1080));
            toolTip.add((class_2561)CreateLang.translateDirect("station." + key + "_1", new Object[0]).method_27692(class_124.field_1080));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        String text = this.nameBox.method_1882();
        if (!this.nameBox.method_25370()) {
            AllGuiTextures.STATION_EDIT_NAME.render(graphics, this.nameBoxX(text, this.nameBox) + this.field_22793.method_1727(text) + 5, y + 1);
        }
        graphics.method_51427(AllItems.TRAIN_DOOR.method_7854(), x + 14, y + 103);
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            class_5250 header = CreateLang.translateDirect("station.idle", new Object[0]);
            graphics.method_51439(this.field_22793, (class_2561)header, x + 97 - this.field_22793.method_27525((class_5348)header) / 2, y + 47, -8750470, false);
            return;
        }
        float position = this.trainPosition.getValue(partialTicks);
        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate(position, 0.0f);
        TrainIcon icon = AllTrainIcons.byType(train.icon);
        int offset = 0;
        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; --i) {
            Carriage carriage = carriages.get(this.blockEntity.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, graphics, x + offset, y + 20) + 1;
        }
        offset += icon.render(-1, graphics, x + offset, y + 20);
        ms.popMatrix();
        AllGuiTextures.STATION_TEXTBOX_TOP.render(graphics, x + 21, y + 42);
        UIRenderHelper.drawStretched(graphics, x + 21, y + 60, 150, 26, AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(graphics, x + 21, y + 86);
        ms.pushMatrix();
        ms.translate(class_3532.method_15363((float)(position + (float)offset - 13.0f), (float)25.0f, (float)159.0f), 0.0f);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(graphics, x, y + 38);
        ms.popMatrix();
        text = this.trainNameBox.method_1882();
        if (!this.trainNameBox.method_25370()) {
            int buttonX = this.nameBoxX(text, this.trainNameBox) + this.field_22793.method_1727(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(graphics, Math.min(buttonX, this.guiLeft + 156), y + 44);
            if (this.field_22793.method_1727(text) > this.trainNameBox.method_25368()) {
                graphics.method_51433(this.field_22793, "...", this.guiLeft + 26, this.guiTop + 47, -5855578, true);
            }
        }
        if (!this.mapModsPresent()) {
            return;
        }
        AllGuiTextures sprite = AllGuiTextures.TRAINMAP_SPRITES;
        sprite.bind();
        int trainColorIndex = this.colorTypeScroll.getState();
        int colorRow = trainColorIndex / 4;
        int colorCol = trainColorIndex % 4;
        int rotation = AnimationTickHolder.getTicks() / 5 % 8;
        for (int slice = 0; slice < 3; ++slice) {
            int row = slice == 0 ? 1 : (slice == 2 ? 2 : 3);
            int col = rotation;
            int positionX = this.colorTypeScroll.method_46426() + 4;
            int positionY = this.colorTypeScroll.method_46427() - 1;
            int sheetX = col * 16 + colorCol * 128;
            int sheetY = row * 16 + colorRow * 64;
            graphics.method_25290(class_10799.field_56883, sprite.location, positionX, positionY, (float)sheetX, (float)sheetY, 16, 16, sprite.getWidth(), sprite.getHeight());
        }
    }

    public boolean mapModsPresent() {
        return false;
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (!this.nameBox.method_25370() && pMouseY > (double)this.guiTop && pMouseY < (double)(this.guiTop + 14) && pMouseX > (double)this.guiLeft && pMouseX < (double)(this.guiLeft + this.background.getWidth())) {
            this.nameBox.method_25365(true);
            this.nameBox.method_1884(0);
            this.method_25395((class_364)this.nameBox);
            return true;
        }
        if (this.trainNameBox.field_22763 && !this.trainNameBox.method_25370() && pMouseY > (double)(this.guiTop + 45) && pMouseY < (double)(this.guiTop + 58) && pMouseX > (double)(this.guiLeft + 25) && pMouseX < (double)(this.guiLeft + 168)) {
            this.trainNameBox.method_25365(true);
            this.trainNameBox.method_1884(0);
            this.method_25395((class_364)this.trainNameBox);
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.method_25399() instanceof class_342 && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.method_25370()) {
            this.nameBox.method_25365(false);
            this.syncStationName();
            return true;
        }
        if (hitEnter && this.trainNameBox.method_25370()) {
            this.trainNameBox.method_25365(false);
            this.syncTrainNameAndColor();
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    private void syncTrainNameAndColor() {
        Train train = (Train)this.displayedTrain.get();
        if (train != null && !this.trainNameBox.method_1882().equals(train.name.getString())) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new TrainEditPacket(train.id, this.trainNameBox.method_1882(), train.icon.id(), train.mapColorIndex));
        }
    }

    private void syncStationName() {
        if (!this.nameBox.method_1882().equals(this.station.name)) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.configure(this.blockEntity.method_11016(), false, this.nameBox.method_1882(), this.doorControl));
        }
    }

    public void method_25432() {
        super.method_25432();
        if (this.nameBox == null || this.trainNameBox == null) {
            return;
        }
        this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.configure(this.blockEntity.method_11016(), this.switchingToAssemblyMode, this.nameBox.method_1882(), this.doorControl));
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            return;
        }
        if (!this.switchingToAssemblyMode) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new TrainEditPacket(train.id, this.trainNameBox.method_1882(), train.icon.id(), train.mapColorIndex));
        } else {
            this.blockEntity.imminentTrain = null;
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return this.blockEntity.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF;
    }
}

