/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.content.trains.track.TrackRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class StandardTrackBlockRenderer
implements TrackBlockRenderer {
    @Override
    public PartialModel prepareAssemblyOverlay(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction, class_4587 ms) {
        TransformStack.of(ms).rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(direction)), class_2350.field_11036);
        return AllPartialModels.TRACK_ASSEMBLING_OVERLAY;
    }

    @Override
    public <Self extends Affine<Self>> PartialModel prepareTrackOverlay(Affine<Self> affine, class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, TrackTargetingBehaviour.RenderedTrackOverlayType type) {
        TrackBlockEntity trackTE;
        class_2586 length2;
        class_2586 class_25862;
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        class_243 offset = null;
        if (bezierPoint != null && (class_25862 = world.method_8321(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)class_25862;
            BezierConnection bc = trackBE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                double length2 = class_3532.method_15357((double)(bc.getLength() * 2.0));
                int seg = bezierPoint.segment() + 1;
                double t = (double)seg / length2;
                double tpre = (double)(seg - 1) / length2;
                double tpost = (double)(seg + 1) / length2;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();
                affine.translate(offset.method_1020(class_243.method_24955((class_2382)pos)));
                affine.translate(0.0f, -0.25f, 0.0f);
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)state.method_11654(TrackBlock.SHAPE))).getAxes().get(0);
            diff = axis.method_1021((double)direction.method_10181()).method_1029();
            normal = ((TrackShape)((Object)state.method_11654(TrackBlock.SHAPE))).getNormal();
        }
        class_243 angles = TrackRenderer.getModelAngles(normal, diff);
        ((Affine)((Affine)((Affine)affine.center()).rotateY((float)angles.field_1351)).rotateX((float)angles.field_1352)).uncenter();
        if (axis != null) {
            affine.translate(0.0f, axis.field_1351 != 0.0 ? 0.4375f : 0.0f, axis.field_1351 != 0.0 ? (float)direction.method_10181() * 2.5f / 16.0f : 0.0f);
        } else {
            affine.translate(0.0f, 0.25f, 0.0f);
            if (direction == class_2350.class_2352.field_11060) {
                affine.rotateCentered((float)Math.PI, class_2350.field_11036);
            }
        }
        if (bezierPoint == null && (length2 = world.method_8321(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)length2).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((class_243)bc.starts.getFirst()).field_1351 - (double)pos.method_10264();
            }
            ((Affine)((Affine)((Affine)affine.center()).rotateXDegrees((float)((double)(-direction.method_10181()) * trackTE.tilt.smoothingAngle.get()))).uncenter()).translate(0.0, yOffset / 2.0, 0.0);
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
    }
}

