/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.gl.array;

import com.zurrtum.create.client.flywheel.backend.gl.GlCompat;
import com.zurrtum.create.client.flywheel.backend.gl.array.GlVertexArray;
import com.zurrtum.create.client.flywheel.backend.gl.array.VertexAttribute;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;

@Environment(value=EnvType.CLIENT)
public class GlVertexArrayDSA
extends GlVertexArray {
    public static final boolean SUPPORTED = GlVertexArrayDSA.isSupported();
    private final BitSet attributeEnabled = new BitSet(MAX_ATTRIBS);
    private final VertexAttribute[] attributes = new VertexAttribute[MAX_ATTRIBS];
    private final int[] attributeBindings = (int[])class_156.method_654((Object)new int[MAX_ATTRIBS], a -> Arrays.fill(a, -1));
    private final int[] bindingBuffers = new int[16];
    private final long[] bindingOffsets = new long[16];
    private final int[] bindingStrides = new int[16];
    private final int[] bindingDivisors = new int[16];
    private int elementBufferBinding = 0;

    public GlVertexArrayDSA() {
        this.handle(GL45C.glCreateVertexArrays());
    }

    @Override
    public void bindVertexBuffer(int bindingIndex, int vbo, long offset, int stride) {
        if (this.bindingBuffers[bindingIndex] != vbo || this.bindingOffsets[bindingIndex] != offset || this.bindingStrides[bindingIndex] != stride) {
            GL45C.glVertexArrayVertexBuffer((int)this.handle(), (int)bindingIndex, (int)vbo, (long)offset, (int)stride);
            this.bindingBuffers[bindingIndex] = vbo;
            this.bindingOffsets[bindingIndex] = offset;
            this.bindingStrides[bindingIndex] = stride;
        }
    }

    @Override
    public void setBindingDivisor(int bindingIndex, int divisor) {
        if (this.bindingDivisors[bindingIndex] != divisor) {
            GL45C.glVertexArrayBindingDivisor((int)this.handle(), (int)bindingIndex, (int)divisor);
            this.bindingDivisors[bindingIndex] = divisor;
        }
    }

    @Override
    public void bindAttributes(int bindingIndex, int startAttribIndex, List<VertexAttribute> vertexAttributes) {
        int handle = this.handle();
        int attribIndex = startAttribIndex;
        int offset = 0;
        for (VertexAttribute attribute : vertexAttributes) {
            if (!this.attributeEnabled.get(attribIndex)) {
                GL45C.glEnableVertexArrayAttrib((int)handle, (int)attribIndex);
                this.attributeEnabled.set(attribIndex);
            }
            if (!attribute.equals(this.attributes[attribIndex])) {
                if (attribute instanceof VertexAttribute.Float) {
                    VertexAttribute.Float f = (VertexAttribute.Float)attribute;
                    GL45C.glVertexArrayAttribFormat((int)handle, (int)attribIndex, (int)f.size(), (int)f.type().glEnum, (boolean)f.normalized(), (int)offset);
                } else if (attribute instanceof VertexAttribute.Int) {
                    VertexAttribute.Int vi = (VertexAttribute.Int)attribute;
                    GL45C.glVertexArrayAttribIFormat((int)handle, (int)attribIndex, (int)vi.size(), (int)vi.type().glEnum, (int)offset);
                }
                this.attributes[attribIndex] = attribute;
            }
            if (this.attributeBindings[attribIndex] != bindingIndex) {
                GL45C.glVertexArrayAttribBinding((int)handle, (int)attribIndex, (int)bindingIndex);
                this.attributeBindings[attribIndex] = bindingIndex;
            }
            ++attribIndex;
            offset += attribute.byteWidth();
        }
    }

    @Override
    public void setElementBuffer(int ebo) {
        if (this.elementBufferBinding != ebo) {
            GL45C.glVertexArrayElementBuffer((int)this.handle(), (int)ebo);
            this.elementBufferBinding = ebo;
        }
    }

    private static boolean isSupported() {
        GLCapabilities c = GlCompat.CAPABILITIES;
        return Checks.checkFunctions((long[])new long[]{c.glCreateVertexArrays, c.glVertexArrayElementBuffer, c.glVertexArrayVertexBuffer, c.glVertexArrayBindingDivisor, c.glVertexArrayAttribBinding, c.glEnableVertexArrayAttrib, c.glVertexArrayAttribFormat, c.glVertexArrayAttribIFormat});
    }
}

