/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBufferer;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockModelBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.ChunkLayerSortedListBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public final class ModelBuilderImpl {
    private ModelBuilderImpl() {
    }

    public static SimpleModel buildBakedModelBuilder(BakedModelBuilder builder) {
        class_2680 blockState = builder.level.method_8320(builder.pos);
        ChunkLayerSortedListBuilder builder1 = ChunkLayerSortedListBuilder.getThreadLocal();
        BakedModelBufferer.ResultConsumer resultConsumer = (renderType, shaded, data) -> {
            Material material = builder.materialFunc.apply(renderType, shaded);
            if (material != null) {
                SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=BakedModelBuilder,bakedModel=" + String.valueOf(builder.bakedModel) + ",renderType=" + String.valueOf(renderType) + ",shaded=" + shaded);
                builder1.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        };
        if (builder.bakedModel != null) {
            BakedModelBufferer.bufferModel(builder.bakedModel, builder.pos, builder.level, blockState, builder.poseStack, resultConsumer);
        } else {
            BakedModelBufferer.bufferModel(builder.model, builder.pos, builder.level, blockState, builder.poseStack, resultConsumer);
        }
        return new SimpleModel((List<Model.ConfiguredMesh>)builder1.build());
    }

    public static SimpleModel buildBlockModelBuilder(BlockModelBuilder builder) {
        ChunkLayerSortedListBuilder builder1 = ChunkLayerSortedListBuilder.getThreadLocal();
        BakedModelBufferer.bufferBlocks(builder.positions.iterator(), builder.level, builder.poseStack, builder.renderFluids, (renderType, shaded, data) -> {
            Material material = builder.materialFunc.apply(renderType, shaded);
            if (material != null) {
                SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=BlockModelBuilder,renderType=" + String.valueOf(renderType) + ",shaded=" + shaded);
                builder1.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder1.build());
    }
}

