/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.task;

import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class Synchronizer
implements Runnable {
    private final AtomicInteger countDown;
    private final Runnable onCompletion;

    public Synchronizer(int countDown, Runnable onCompletion) {
        this.countDown = new AtomicInteger(countDown);
        this.onCompletion = onCompletion;
    }

    public void decrementAndEventuallyRun() {
        if (this.countDown.decrementAndGet() == 0) {
            this.onCompletion.run();
        }
    }

    @Override
    public void run() {
        this.decrementAndEventuallyRun();
    }
}

