/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.entity.behaviour;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1146;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_359;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class CarriageAudioBehaviour
extends EntityBehaviour<CarriageContraptionEntity> {
    public static final BehaviourType<CarriageAudioBehaviour> TYPE = new BehaviourType();
    LerpedFloat distanceFactor = LerpedFloat.linear();
    LerpedFloat speedFactor = LerpedFloat.linear();
    LerpedFloat approachFactor = LerpedFloat.linear();
    LerpedFloat seatCrossfade = LerpedFloat.linear();
    LoopingSound minecartEsqueSound;
    LoopingSound sharedWheelSound;
    LoopingSound sharedWheelSoundSeated;
    LoopingSound sharedHonkSound;
    Couple<class_3414> bogeySounds;
    class_3414 closestBogeySound;
    boolean arrived = true;
    int tick;
    int prevSharedTick;

    public CarriageAudioBehaviour(CarriageContraptionEntity entity) {
        super(entity);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public void tick() {
        AllSoundEvents.SoundEntry continuousSound;
        double distance2;
        Contraption contraption = ((CarriageContraptionEntity)this.entity).getContraption();
        if (contraption == null) {
            return;
        }
        if (!(contraption instanceof CarriageContraption)) {
            return;
        }
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (carriage == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_1297 camEntity = mc.field_1719;
        if (camEntity == null) {
            return;
        }
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(((CarriageContraptionEntity)this.entity).method_37908());
        if (!dce.pointsInitialised) {
            return;
        }
        class_243 leadingAnchor = dce.leadingAnchor();
        if (leadingAnchor == null) {
            return;
        }
        class_243 trailingAnchor = dce.trailingAnchor();
        if (trailingAnchor == null) {
            return;
        }
        if (this.bogeySounds == null) {
            this.bogeySounds = carriage.bogeys.map(bogey -> bogey != null && bogey.getStyle() != null ? bogey.getStyle().soundEvent.get() : AllSoundEvents.TRAIN2.getMainEvent());
            this.closestBogeySound = (class_3414)this.bogeySounds.getFirst();
        }
        ++this.tick;
        class_243 cam = camEntity.method_33571();
        class_243 contraptionMotion = ((CarriageContraptionEntity)this.entity).method_19538().method_1020(((CarriageContraptionEntity)this.entity).getPrevPositionVec());
        class_243 combinedMotion = contraptionMotion.method_1020(camEntity.method_18798());
        Train train = carriage.train;
        if (this.arrived && contraptionMotion.method_1033() > (double)0.01f) {
            this.arrived = false;
        }
        if (this.arrived && ((CarriageContraptionEntity)this.entity).carriageIndex == 0) {
            train.accumulatedSteamRelease /= 2.0f;
        }
        this.arrived |= ((CarriageContraptionEntity)this.entity).isStalled();
        if (((CarriageContraptionEntity)this.entity).carriageIndex == 0) {
            train.accumulatedSteamRelease = (float)Math.min((double)train.accumulatedSteamRelease + Math.min(0.5, Math.abs(contraptionMotion.method_1033() / 10.0)), 10.0);
        }
        class_243 toBogey1 = leadingAnchor.method_1020(cam);
        class_243 toBogey2 = trailingAnchor.method_1020(cam);
        Couple<CarriageBogey> bogeys = carriage.bogeys;
        double distance1 = toBogey1.method_1033();
        CarriageBogey relevantBogey = bogeys.get(distance1 > (distance2 = toBogey2.method_1033()));
        if (relevantBogey == null) {
            relevantBogey = (CarriageBogey)bogeys.getFirst();
        }
        if (relevantBogey != null) {
            this.closestBogeySound = relevantBogey.getStyle().soundEvent.get();
        }
        class_243 toCarriage = distance1 > distance2 ? toBogey2 : toBogey1;
        double distance = Math.min(distance1, distance2);
        class_243 soundLocation = cam.method_1019(toCarriage);
        double dot = toCarriage.method_1029().method_1026(combinedMotion.method_1029());
        this.speedFactor.chase(contraptionMotion.method_1033(), 0.25, LerpedFloat.Chaser.exp(0.05f));
        this.distanceFactor.chase(class_3532.method_15390((double)100.0, (double)0.0, (double)((distance - 3.0) / 64.0)), 0.25, LerpedFloat.Chaser.exp(50.0));
        this.approachFactor.chase(class_3532.method_15390((double)50.0, (double)200.0, (double)(0.5 * (dot + 1.0))), 0.25, LerpedFloat.Chaser.exp(10.0));
        this.seatCrossfade.chase(camEntity.method_5854() instanceof CarriageContraptionEntity ? 1.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.speedFactor.tickChaser();
        this.distanceFactor.tickChaser();
        this.approachFactor.tickChaser();
        this.seatCrossfade.tickChaser();
        this.minecartEsqueSound = this.playIfMissing(mc, this.minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        this.sharedWheelSound = this.playIfMissing(mc, this.sharedWheelSound, this.closestBogeySound);
        this.sharedWheelSoundSeated = this.playIfMissing(mc, this.sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());
        float volume = Math.min(Math.min(this.speedFactor.getValue(), this.distanceFactor.getValue() / 100.0f), this.approachFactor.getValue() / 300.0f + 0.0125f);
        if (((CarriageContraptionEntity)this.entity).carriageIndex == 0) {
            float v = volume * (1.0f - this.seatCrossfade.getValue() * 0.35f) * 0.75f;
            if ((3 + this.tick) % 4 == 0) {
                AllSoundEvents.STEAM.playAt(((CarriageContraptionEntity)this.entity).method_37908(), soundLocation, v * ((this.tick + 7) % 8 == 0 ? 0.75f : 0.45f), 1.17f, false);
            }
            if (this.tick % 16 == 0) {
                AllSoundEvents.STEAM.playAt(((CarriageContraptionEntity)this.entity).method_37908(), soundLocation, v * 1.5f, 0.8f, false);
            }
        }
        if (!this.arrived && this.speedFactor.getValue() < 0.002f && train.accumulatedSteamRelease > 1.0f) {
            this.arrived = true;
            float releaseVolume = train.accumulatedSteamRelease / 10.0f;
            ((CarriageContraptionEntity)this.entity).method_37908().method_8486(soundLocation.field_1352, soundLocation.field_1351, soundLocation.field_1350, class_3417.field_19198, class_3419.field_15254, 0.25f * releaseVolume, 0.78f, false);
            ((CarriageContraptionEntity)this.entity).method_37908().method_8486(soundLocation.field_1352, soundLocation.field_1351, soundLocation.field_1350, class_3417.field_15080, class_3419.field_15254, 0.2f * releaseVolume, 1.5f, false);
            AllSoundEvents.STEAM.playAt(((CarriageContraptionEntity)this.entity).method_37908(), soundLocation, 0.75f * releaseVolume, 0.5f, false);
        }
        float pitchModifier = (float)(((CarriageContraptionEntity)this.entity).method_5628() * 10 % 13) / 36.0f;
        volume = Math.min(volume, this.distanceFactor.getValue() / 800.0f);
        float pitch = class_3532.method_15363((float)(this.speedFactor.getValue() * 2.0f + 0.25f), (float)0.75f, (float)1.95f) - pitchModifier;
        this.minecartEsqueSound.setPitch(pitch * 1.5f);
        volume = Math.min(volume, this.distanceFactor.getValue() / 1000.0f);
        for (Carriage trainCarriage : train.carriages) {
            CarriageContraptionEntity mainEntity;
            Carriage.DimensionalCarriageEntity mainDCE = carriage.getDimensionalIfPresent((class_5321<class_1937>)((CarriageContraptionEntity)this.entity).method_37908().method_27983());
            if (mainDCE == null || (mainEntity = (CarriageContraptionEntity)((Object)mainDCE.entity.get())) == null) continue;
            CarriageAudioBehaviour behaviour = mainEntity.getBehaviour(TYPE);
            if (behaviour != null) {
                behaviour.submitSharedSoundVolume(mc, soundLocation, volume);
            }
            if (trainCarriage == carriage) break;
            this.finalizeSharedVolume(0.0f);
            return;
        }
        if (train.honkTicks == 0) {
            if (this.sharedHonkSound != null) {
                this.sharedHonkSound.stopSound();
                this.sharedHonkSound = null;
            }
            return;
        }
        --train.honkTicks;
        train.determineHonk(((CarriageContraptionEntity)this.entity).method_37908());
        if (train.lowHonk == null) {
            return;
        }
        boolean low = train.lowHonk;
        float honkPitch = (float)Math.pow(2.0, (double)train.honkPitch / 12.0);
        AllSoundEvents.SoundEntry endSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL_END : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW_END;
        AllSoundEvents.SoundEntry soundEntry = continuousSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW;
        if (train.honkTicks == 5) {
            endSound.playAt((class_1937)mc.field_1687, soundLocation, 1.0f, honkPitch, false);
        }
        if (train.honkTicks == 19) {
            endSound.playAt((class_1937)mc.field_1687, soundLocation, 0.5f, honkPitch, false);
        }
        this.sharedHonkSound = this.playIfMissing(mc, this.sharedHonkSound, continuousSound.getMainEvent(), true);
        this.sharedHonkSound.setLocation(soundLocation);
        float fadeout = class_3532.method_15363((float)((float)(3 - train.honkTicks) / 3.0f), (float)0.0f, (float)1.0f);
        float fadein = class_3532.method_15363((float)((float)(train.honkTicks - 17) / 3.0f), (float)0.0f, (float)1.0f);
        this.sharedHonkSound.setVolume(1.0f - fadeout - fadein);
        this.sharedHonkSound.setPitch(honkPitch);
    }

    private LoopingSound playIfMissing(class_310 mc, LoopingSound loopingSound, class_3414 sound) {
        return this.playIfMissing(mc, loopingSound, sound, false);
    }

    private LoopingSound playIfMissing(class_310 mc, LoopingSound loopingSound, class_3414 sound, boolean continuouslyShowSubtitle) {
        if (loopingSound == null) {
            loopingSound = new LoopingSound(sound, class_3419.field_15254, continuouslyShowSubtitle);
            mc.method_1483().method_4873((class_1113)loopingSound);
        }
        return loopingSound;
    }

    public void submitSharedSoundVolume(class_310 mc, class_243 location, float volume) {
        this.minecartEsqueSound = this.playIfMissing(mc, this.minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        this.sharedWheelSound = this.playIfMissing(mc, this.sharedWheelSound, this.closestBogeySound);
        this.sharedWheelSoundSeated = this.playIfMissing(mc, this.sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());
        boolean approach = true;
        if (this.tick != this.prevSharedTick) {
            this.prevSharedTick = this.tick;
            approach = false;
        } else if (this.sharedWheelSound.method_4781() > volume) {
            return;
        }
        class_243 currentLoc = new class_243(this.minecartEsqueSound.method_4784(), this.minecartEsqueSound.method_4779(), this.minecartEsqueSound.method_4778());
        class_243 newLoc = approach ? currentLoc.method_1019(location.method_1020(currentLoc).method_1021(0.125)) : location;
        this.minecartEsqueSound.setLocation(newLoc);
        this.sharedWheelSound.setLocation(newLoc);
        this.sharedWheelSoundSeated.setLocation(newLoc);
        this.finalizeSharedVolume(volume);
    }

    public void finalizeSharedVolume(float volume) {
        float crossfade = this.seatCrossfade.getValue();
        this.minecartEsqueSound.setVolume((1.0f - crossfade * 0.65f) * volume / 2.0f);
        volume = Math.min(volume, Math.max((this.speedFactor.getValue() - 0.25f) / 4.0f + 0.01f, 0.0f));
        this.sharedWheelSoundSeated.setVolume(volume * crossfade);
        this.sharedWheelSound.setVolume(volume * (1.0f - crossfade) * 1.5f);
    }

    @Override
    public void destroy() {
        if (this.minecartEsqueSound != null) {
            this.minecartEsqueSound.stopSound();
        }
        if (this.sharedWheelSound != null) {
            this.sharedWheelSound.stopSound();
        }
        if (this.sharedWheelSoundSeated != null) {
            this.sharedWheelSoundSeated.stopSound();
        }
        if (this.sharedHonkSound != null) {
            this.sharedHonkSound.stopSound();
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class LoopingSound
    extends class_1101 {
        private static final class_359 OVERLAY = class_310.method_1551().field_1705.field_2027;
        private final boolean repeatSubtitle;
        private final class_1146 weighedSoundEvents = this.method_4783(class_310.method_1551().method_1483());
        private byte subtitleTimer = 0;

        protected LoopingSound(class_3414 soundEvent, class_3419 source, boolean repeatSubtitle) {
            super(soundEvent, source, class_1113.method_43221());
            this.field_5446 = true;
            this.field_5451 = 0;
            this.field_5442 = 1.0E-4f;
            this.repeatSubtitle = repeatSubtitle;
        }

        public void method_16896() {
            if (this.repeatSubtitle) {
                this.subtitleTimer = (byte)(this.subtitleTimer + 1);
                if (this.subtitleTimer == 20) {
                    OVERLAY.method_4884((class_1113)this, this.weighedSoundEvents, (float)this.field_5444.method_4770());
                    this.subtitleTimer = 0;
                }
            }
        }

        public void setVolume(float volume) {
            this.field_5442 = volume;
        }

        public float method_4781() {
            return this.field_5442;
        }

        public void setPitch(float pitch) {
            this.field_5441 = pitch;
        }

        public float method_4782() {
            return this.field_5441;
        }

        public void setLocation(class_243 location) {
            this.field_5439 = location.field_1352;
            this.field_5450 = location.field_1351;
            this.field_5449 = location.field_1350;
        }

        public void stopSound() {
            class_310.method_1551().method_1483().method_4870((class_1113)this);
        }
    }
}

