/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.menu;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.TickableGuiEventListener;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_768;
import net.minecraft.class_9129;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractSimiContainerScreen<T extends class_1703>
extends class_465<T> {
    public static GpuBufferSlice projectionMatrixBuffer;
    public static class_10366 projectionType;
    protected int windowXOffset;
    protected int windowYOffset;

    public static void backupProjectionMatrix() {
        projectionMatrixBuffer = RenderSystem.getProjectionMatrixBuffer();
        projectionType = RenderSystem.getProjectionType();
    }

    public static void restoreProjectionMatrix() {
        RenderSystem.setProjectionMatrix((GpuBufferSlice)projectionMatrixBuffer, (class_10366)projectionType);
    }

    public AbstractSimiContainerScreen(T container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
    }

    protected void setWindowSize(int width, int height) {
        this.field_2792 = width;
        this.field_2779 = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 += this.windowXOffset;
        this.field_2800 += this.windowYOffset;
    }

    protected void method_37432() {
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    protected <W extends class_364 & class_4068> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.method_37063((class_364)widget);
        }
    }

    protected <W extends class_364 & class_4068> void addRenderableWidgets(Collection<W> widgets) {
        for (class_364 widget : widgets) {
            this.method_37063(widget);
        }
    }

    protected void removeWidgets(class_364 ... widgets) {
        for (class_364 widget : widgets) {
            this.method_37066(widget);
        }
    }

    protected void removeWidgets(Collection<? extends class_364> widgets) {
        for (class_364 class_3642 : widgets) {
            this.method_37066(class_3642);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = AnimationTickHolder.getPartialTicksUI(this.field_22787.method_61966());
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_2380(graphics, mouseX, mouseY);
        for (class_4068 widget : this.field_33816) {
            List<class_2561> tooltip;
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).method_25405(mouseX, mouseY) || (tooltip = simiWidget.getToolTip()).isEmpty()) continue;
            int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.method_46426();
            int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.method_46427();
            graphics.method_51434(this.field_22793, tooltip, ttx, tty);
        }
    }

    public int getLeftOfCentered(int textureWidth) {
        return this.field_2776 - this.windowXOffset + (this.field_2792 - textureWidth) / 2;
    }

    public void renderPlayerInventory(class_332 graphics, int x, int y) {
        AllGuiTextures.PLAYER_INVENTORY.render(graphics, x, y);
        graphics.method_51439(this.field_22793, this.field_29347, x + 8, y + 6, -12566464, false);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.method_25399() instanceof class_342 && pKeyCode != 256) {
            return this.method_25399().method_25404(pKeyCode, pScanCode, pModifiers);
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.method_25399() != null && !this.method_25399().method_25405(pMouseX, pMouseY)) {
            this.method_25395(null);
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public class_364 method_25399() {
        class_364 focused = super.method_25399();
        if (focused instanceof class_339 && !focused.method_25370()) {
            focused = null;
        }
        this.method_25395(focused);
        return focused;
    }

    public List<class_768> getExtraAreas() {
        return Collections.emptyList();
    }

    @Deprecated
    protected void debugWindowArea(class_332 graphics) {
        graphics.method_25294(this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, this.field_2776, this.field_2800, -741092397);
    }

    @Deprecated
    protected void debugExtraAreas(class_332 graphics) {
        for (class_768 area : this.getExtraAreas()) {
            graphics.method_25294(area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), area.method_3321(), area.method_3322(), -741092397);
        }
    }

    protected void playUiSound(class_3414 sound, float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)(volume * 0.25f)));
    }

    public static class_1799 getStack(class_9129 extraData) {
        return (class_1799)class_1799.field_48349.decode((Object)extraData);
    }

    public static <T extends class_2586> T getBlockEntity(class_310 mc, class_9129 extraData) {
        class_638 world = mc.field_1687;
        if (world == null) {
            return null;
        }
        return (T)world.method_8321(extraData.method_10811());
    }
}

