/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.client.foundation.model.BakedQuadHelper;
import com.zurrtum.create.client.infrastructure.model.CopycatModel;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatPanelBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatSpecialCases;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class CopycatPanelModel
extends CopycatModel {
    protected static final class_238 CUBE_AABB = new class_238(class_2338.field_10980);

    public CopycatPanelModel(class_2680 state, class_1087.class_9979 unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, CopycatBlock block, class_2680 material, class_5819 random, List<class_10889> parts) {
        if (CopycatSpecialCases.isTrapdoorMaterial(material)) {
            this.addModelParts(world, pos, material, random, CopycatPanelModel.getModelOf(material), parts);
            return;
        }
        CopycatModel.OcclusionData occlusionData = this.gatherOcclusionData(world, pos, state, material, block);
        if (CopycatSpecialCases.isBarsMaterial(material)) {
            class_2350 facing = (class_2350)state.method_61767(CopycatPanelBlock.FACING, (Comparable)class_2350.field_11036);
            class_2680 bars = (class_2680)AllBlocks.COPYCAT_BARS.method_9564().method_11657((class_2769)WrenchableDirectionalBlock.field_10927, (Comparable)facing);
            class_1087 model = CopycatPanelModel.getModelOf(material);
            this.addBarsParts(occlusionData, state, block, model.method_68511(), this.getMaterialParts(world, pos, material, random, model), this.getMaterialParts(world, pos, material, random, CopycatPanelModel.getModelOf(bars)), parts);
        } else {
            this.addPanelParts(occlusionData, state, block, this.getMaterialParts(world, pos, material, random, CopycatPanelModel.getModelOf(material)), parts);
        }
    }

    protected void addBarsParts(CopycatModel.OcclusionData occlusionData, class_2680 state, CopycatBlock block, class_1058 particle, List<class_10889> material, List<class_10889> original, List<class_10889> parts) {
        boolean vertical = ((class_2350)state.method_11654(CopycatPanelBlock.FACING)).method_10166() == class_2350.class_2351.field_11052;
        class_1058 findSprite = null;
        for (class_10889 part : original) {
            class_10817.class_10818 builder = new class_10817.class_10818();
            this.addBarsCroppedQuads(particle, part.method_68509(null), arg_0 -> ((class_10817.class_10818)builder).method_68051(arg_0));
            for (class_2350 direction : Iterate.directions) {
                if (occlusionData.isOccluded(direction)) continue;
                List quads = part.method_68509(direction);
                class_1058 targetSprite = particle;
                if (vertical || direction.method_10166() == class_2350.class_2351.field_11052) {
                    if (findSprite != null) {
                        targetSprite = findSprite;
                    } else {
                        block2: for (class_10889 materialPart : material) {
                            for (class_777 quad2 : materialPart.method_68509(null)) {
                                if (quad2.comp_3723() != class_2350.field_11036) continue;
                                targetSprite = findSprite = quad2.comp_3724();
                                continue block2;
                            }
                        }
                        if (findSprite == null) {
                            findSprite = particle;
                        }
                    }
                }
                this.addBarsCroppedQuads(targetSprite, quads, block.shouldFaceAlwaysRender(state, direction) ? arg_0 -> ((class_10817.class_10818)builder).method_68051(arg_0) : quad -> builder.method_68053(direction, quad));
            }
            parts.add((class_10889)new class_10801(builder.method_68050(), part.comp_3751(), part.comp_3752()));
        }
    }

    protected void addBarsCroppedQuads(class_1058 targetSprite, List<class_777> quads, Consumer<class_777> consumer) {
        if (targetSprite == null) {
            quads.forEach(consumer);
            return;
        }
        for (class_777 quad : quads) {
            class_1058 original = quad.comp_3724();
            class_777 newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.comp_3721();
            for (int vertex = 0; vertex < 4; ++vertex) {
                BakedQuadHelper.setU(vertexData, vertex, targetSprite.method_4580(SpriteShiftEntry.getUnInterpolatedU(original, BakedQuadHelper.getU(vertexData, vertex))));
                BakedQuadHelper.setV(vertexData, vertex, targetSprite.method_4570(SpriteShiftEntry.getUnInterpolatedV(original, BakedQuadHelper.getV(vertexData, vertex))));
            }
            consumer.accept(newQuad);
        }
    }

    protected void addPanelParts(CopycatModel.OcclusionData occlusionData, class_2680 state, CopycatBlock block, List<class_10889> original, List<class_10889> parts) {
        if (original.isEmpty()) {
            return;
        }
        class_2350 facing = (class_2350)state.method_61767(CopycatPanelBlock.FACING, (Comparable)class_2350.field_11036);
        class_243 normal = class_243.method_24954((class_2382)facing.method_62675());
        class_243 normalScaled14 = normal.method_1021(0.875);
        class_243 frontNormalScaledN13 = normal.method_1021(0.0);
        class_243 normalScaledN13 = normal.method_1021(-0.8125);
        double frontContract = 0.9375;
        double contract = 0.875;
        class_238 frontBB = CUBE_AABB.method_1002(normal.field_1352 * frontContract, normal.field_1351 * frontContract, normal.field_1350 * frontContract);
        class_238 bb = CUBE_AABB.method_1002(normal.field_1352 * contract, normal.field_1351 * contract, normal.field_1350 * contract).method_997(normalScaled14);
        for (class_10889 part : original) {
            class_10817.class_10818 builder = new class_10817.class_10818();
            this.addPanelCroppedQuads(facing, frontBB, bb, frontNormalScaledN13, normalScaledN13, part.method_68509(null), arg_0 -> ((class_10817.class_10818)builder).method_68051(arg_0));
            for (class_2350 direction : Iterate.directions) {
                if (occlusionData.isOccluded(direction)) continue;
                this.addPanelCroppedQuads(facing, frontBB, bb, frontNormalScaledN13, normalScaledN13, part.method_68509(direction), block.shouldFaceAlwaysRender(state, direction) ? arg_0 -> ((class_10817.class_10818)builder).method_68051(arg_0) : quad -> builder.method_68053(direction, quad));
            }
            parts.add((class_10889)new class_10801(builder.method_68050(), part.comp_3751(), part.comp_3752()));
        }
    }

    protected void addPanelCroppedQuads(class_2350 facing, class_238 frontBB, class_238 bb, class_243 frontNormalScaledN13, class_243 normalScaledN13, List<class_777> quads, Consumer<class_777> consumer) {
        int size = quads.size();
        if (size == 0) {
            return;
        }
        for (boolean front : Iterate.trueAndFalse) {
            class_243 move;
            class_238 crop;
            if (front) {
                crop = frontBB;
                move = frontNormalScaledN13;
            } else {
                crop = bb;
                move = normalScaledN13;
            }
            for (int i = 0; i < size; ++i) {
                class_777 quad = quads.get(i);
                class_2350 direction = quad.comp_3723();
                if (front && direction == facing || !front && direction == facing.method_10153()) continue;
                consumer.accept(BakedQuadHelper.cloneWithCustomGeometry(quad, BakedModelHelper.cropAndMove(quad.comp_3721(), quad.comp_3724(), crop, move)));
            }
        }
    }
}

