/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class PostboxScenes {
    public static void postbox(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("postbox", "Transporting packages between Postboxes");
        scene.configureBasePlate(0, 1, 9);
        scene.scaleSceneView(0.875f);
        scene.removeShadow();
        scene.setSceneOffsetY(-0.5f);
        class_2338 station = util.grid().at(1, 1, 8);
        Selection stationS = util.select().position(1, 1, 8);
        class_2338 box2 = util.grid().at(3, 1, 8);
        Selection box2S = util.select().position(3, 1, 8);
        Selection glass = util.select().fromTo(3, 1, 9, 1, 1, 9);
        class_2338 box = util.grid().at(1, 2, 2);
        Selection boxS = util.select().position(1, 2, 2);
        Selection girder = util.select().position(1, 1, 2);
        Selection belt = util.select().fromTo(4, 1, 2, 2, 1, 2);
        Selection cog = util.select().fromTo(4, 1, 1, 4, 1, 0);
        Selection largeCog = util.select().position(5, 0, 0);
        Selection train1 = util.select().fromTo(0, 2, 4, 3, 3, 6);
        Selection train2 = util.select().fromTo(4, 2, 4, 8, 3, 6);
        class_2338 controls = util.grid().at(2, 3, 5);
        Selection tracks = util.select().fromTo(9, 1, 5, 30, 1, 5);
        class_2338 funnel = util.grid().at(2, 2, 2);
        class_1799 boxItem2 = PackageItem.containing(List.of());
        PackageItem.addAddress(boxItem2, "Peter");
        scene.world().createItemOnBeltLike(util.grid().at(6, 2, 4), class_2350.field_11033, boxItem2);
        scene.world().toggleControls(controls);
        ElementLink<WorldSectionElement> base = scene.world().showIndependentSection(util.select().fromTo(0, 0, 1, 8, 0, 9), class_2350.field_11036);
        scene.idle(10);
        ElementLink<WorldSectionElement> tracksL = scene.world().showIndependentSection(util.select().position(8, 1, 5), class_2350.field_11033);
        scene.idle(1);
        for (int i = 7; i >= 0; --i) {
            scene.world().showSectionAndMerge(util.select().position(i, 1, 5), class_2350.field_11033, tracksL);
            scene.idle(1);
        }
        scene.idle(5);
        scene.world().showSectionAndMerge(stationS, class_2350.field_11033, base);
        scene.idle(15);
        class_243 fromTarget = util.vector().topOf(station);
        class_1799 postboxItem = AllItems.WHITE_POSTBOX.method_7854();
        scene.overlay().showControls(fromTarget, Pointing.DOWN, 50).rightClick().withItem(postboxItem);
        scene.idle(5);
        class_238 bb1 = new class_238(fromTarget, fromTarget);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, box, bb1, 10);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, box, bb1.method_1009(0.025, 0.025, 0.025), 50);
        scene.idle(26);
        scene.overlay().showText(80).text("Right-click a Train Station and place the Postbox nearby").attachKeyFrame().placeNearTarget().pointAt(fromTarget);
        scene.idle(40);
        ElementLink<WorldSectionElement> postboxE = scene.world().showIndependentSection(boxS, class_2350.field_11033);
        scene.world().moveSection(postboxE, util.vector().of(0.0, -1.0, 0.0), 0);
        scene.idle(15);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, box, bb1.method_1009(0.025, 0.025, 0.025), 50);
        class_238 bb2 = new class_238(box.method_10074()).method_35580(0.125, 0.0, 0.0).method_1002(0.0, 0.125, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, box2, bb2, 50);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, util.vector().topOf(box.method_10074()), fromTarget, 40);
        scene.idle(45);
        scene.overlay().showControls(util.vector().topOf(box.method_10074()), Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, funnel, bb2, 70);
        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.BLUE).text("Assign it an address in the inventory UI").pointAt(util.vector().topOf(box.method_10074())).placeNearTarget();
        scene.idle(80);
        scene.world().moveSection(postboxE, util.vector().of(0.0, 1.0, 0.0), 10);
        scene.idle(10);
        scene.world().showSectionAndMerge(girder, class_2350.field_11043, base);
        scene.idle(5);
        scene.world().showSectionAndMerge(largeCog, class_2350.field_11036, base);
        scene.world().showSectionAndMerge(cog, class_2350.field_11033, base);
        scene.world().showSectionAndMerge(belt, class_2350.field_11039, base);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(funnel), class_2350.field_11033, base);
        scene.idle(10);
        class_1799 boxItem = PackageStyles.getDefaultBox().method_7972();
        PackageItem.addAddress(boxItem, "Peter");
        scene.world().createItemOnBelt(util.grid().at(3, 1, 2), class_2350.field_11034, boxItem);
        scene.idle(5);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.03125f);
        scene.overlay().showText(60).attachKeyFrame().text("If the address of an inserted package does not match it..").pointAt(util.vector().centerOf(3, 2, 2)).placeNearTarget();
        scene.idle(70);
        scene.overlay().showText(40).colored(PonderPalette.BLUE).text("Warehouse").pointAt(util.vector().blockSurface(box, class_2350.field_11043).method_1031(-0.5, 0.0, 0.0)).placeNearTarget();
        scene.idle(5);
        scene.overlay().showText(40).colored(PonderPalette.OUTPUT).text("\u2192 Outpost").pointAt(util.vector().centerOf(3, 2, 2)).placeNearTarget();
        scene.idle(50);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 32.0f);
        scene.idle(17);
        scene.world().removeItemsFromBelt(util.grid().at(2, 1, 2));
        PostboxScenes.animatePostbox(scene, box, true);
        scene.world().flapFunnel(funnel, false);
        scene.idle(15);
        ElementLink<WorldSectionElement> train1L = scene.world().showIndependentSection(train1, null);
        ElementLink<ParrotElement> birbL = scene.special().createBirb(util.vector().of(9.5, 3.5, 5.5), ParrotPose.FacePointOfInterestPose::new);
        scene.special().movePointOfInterest(util.grid().at(-5, 4, 5));
        scene.world().moveSection(train1L, util.vector().of(6.0, 0.0, 0.0), 0);
        scene.idle(1);
        scene.special().moveParrot(birbL, util.vector().of(-5.0, 0.0, 0.0), 25);
        scene.world().moveSection(train1L, util.vector().of(-5.0, 0.0, 0.0), 25);
        scene.world().animateBogey(util.grid().at(2, 2, 5), 6.0f, 25);
        scene.idle(14);
        ElementLink<WorldSectionElement> train2L = scene.world().showIndependentSection(train2, null);
        scene.world().moveSection(train2L, util.vector().of(3.0, 0.0, 0.0), 0);
        scene.idle(1);
        scene.world().moveSection(train2L, util.vector().of(-2.0, 0.0, 0.0), 10);
        scene.world().animateBogey(util.grid().at(6, 2, 5), 2.0f, 10);
        scene.idle(10);
        scene.special().moveParrot(birbL, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.world().moveSection(train1L, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.world().animateBogey(util.grid().at(2, 2, 5), 1.0f, 10);
        scene.world().moveSection(train2L, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.world().animateBogey(util.grid().at(6, 2, 5), 1.0f, 10);
        scene.idle(10);
        scene.world().animateTrainStation(station, true);
        scene.idle(10);
        scene.effects().indicateSuccess(box);
        scene.effects().indicateSuccess(util.grid().at(5, 3, 4));
        scene.world().createItemOnBeltLike(util.grid().at(5, 2, 4), class_2350.field_11033, boxItem);
        scene.idle(15);
        PostboxScenes.animatePostbox(scene, box, false);
        scene.overlay().showText(80).text("..trains stopping at the station will collect it as cargo").attachKeyFrame().pointAt(util.vector().topOf(5, 2, 4)).placeNearTarget();
        scene.idle(95);
        scene.overlay().showText(80).text("Conversely, packages matching the address will be dropped off").attachKeyFrame().pointAt(util.vector().topOf(6, 2, 4)).placeNearTarget();
        scene.idle(50);
        scene.world().removeItemsFromBelt(util.grid().at(6, 2, 4));
        scene.effects().indicateSuccess(box);
        scene.effects().indicateSuccess(util.grid().at(6, 2, 4));
        PostboxScenes.animatePostbox(scene, box, true);
        scene.idle(60);
        scene.overlay().showText(100).text("Packages that arrived by train can be extracted from the Postbox").attachKeyFrame().pointAt(util.vector().blockSurface(box, class_2350.field_11043)).placeNearTarget();
        scene.idle(60);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), -1.0f);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 2), class_2350.field_11039, boxItem2);
        PostboxScenes.animatePostbox(scene, box, false);
        scene.idle(25);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(25);
        scene.overlay().showText(40).colored(PonderPalette.BLUE).text("Warehouse").pointAt(util.vector().blockSurface(box, class_2350.field_11043).method_1031(-0.5, 0.0, 0.0)).placeNearTarget();
        scene.idle(5);
        scene.overlay().showText(40).colored(PonderPalette.OUTPUT).text("\u2192 Warehouse").pointAt(util.vector().centerOf(3, 2, 2).method_1031(0.0, -0.25, 0.0)).placeNearTarget();
        scene.idle(50);
        ElementLink<WorldSectionElement> tracksL2 = scene.world().showIndependentSection(tracks, class_2350.field_11034);
        scene.world().moveSection(tracksL2, util.vector().of(-31.0, 0.0, 0.0), 0);
        scene.idle(15);
        scene.world().animateTrainStation(station, false);
        scene.world().moveSection(tracksL, util.vector().of(12.0, 0.0, 0.0), 120);
        scene.world().moveSection(tracksL2, util.vector().of(12.0, 0.0, 0.0), 120);
        scene.world().moveSection(postboxE, util.vector().of(12.0, 0.0, 0.0), 120);
        scene.world().moveSection(base, util.vector().of(12.0, 0.0, 0.0), 120);
        scene.world().animateBogey(util.grid().at(2, 2, 5), 12.0f, 120);
        scene.world().animateBogey(util.grid().at(6, 2, 5), 12.0f, 120);
        scene.idle(15);
        scene.world().hideIndependentSection(base, null);
        scene.world().hideIndependentSection(postboxE, null);
        scene.idle(40);
        scene.special().hideElement(birbL, null);
        scene.world().hideIndependentSection(train1L, null);
        scene.world().hideIndependentSection(train2L, null);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, train1L, new class_238(util.grid().at(1, 3, 4)).method_1009(1.0, 0.75, 0.5), 280);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, train2L, new class_238(util.grid().at(5, 3, 4)).method_1009(1.0, 0.75, 0.5), 280);
        scene.idle(19);
        ElementLink<WorldSectionElement> outpostL = scene.world().showIndependentSection(glass, class_2350.field_11036);
        scene.world().moveSection(outpostL, util.vector().of(-4.0, -1.0, -1.0), 0);
        scene.idle(1);
        scene.world().moveSection(outpostL, util.vector().of(4.0, 0.0, 0.0), 40);
        scene.idle(9);
        ElementLink<WorldSectionElement> stationL = scene.world().showIndependentSection(stationS.add(box2S), class_2350.field_11033);
        scene.world().moveSection(stationL, util.vector().of(-3.0, 0.0, 0.0), 0);
        scene.idle(1);
        scene.world().moveSection(stationL, util.vector().of(3.0, 0.0, 0.0), 30);
        scene.idle(30);
        scene.world().animateTrainStation(util.grid().at(1, 1, 8), true);
        scene.idle(10);
        scene.overlay().showText(90).text("Just like trains, Postboxes maintain their behaviour in unloaded chunks").colored(PonderPalette.BLUE).attachKeyFrame().independent(30);
        scene.idle(100);
        scene.effects().indicateSuccess(util.grid().at(3, 1, 8));
        PostboxScenes.animatePostbox(scene, util.grid().at(3, 1, 8), true);
        scene.overlay().showText(90).text("Packages can still be delivered from or to their inventory").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 8), class_2350.field_11043));
        scene.idle(80);
    }

    public static void animatePostbox(CreateSceneBuilder scene, class_2338 box, boolean raise) {
        scene.world().modifyBlockEntity(box, PostboxBlockEntity.class, be -> {
            be.forceFlag = raise;
        });
    }
}

