/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class FadeOutOfSceneInstruction<T extends AnimatedSceneElement>
extends TickingInstruction {
    private final class_2350 fadeOutTo;
    private final ElementLink<T> link;
    private T element;

    public FadeOutOfSceneInstruction(int fadeOutTicks, class_2350 fadeOutTo, ElementLink<T> link) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo == null ? null : fadeOutTo.method_10153();
        this.link = link;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.element = (AnimatedSceneElement)scene.resolve(this.link);
        if (this.element == null) {
            return;
        }
        this.element.setVisible(true);
        this.element.setFade(1.0f);
        this.element.setFadeVec(this.fadeOutTo == null ? class_243.field_1353 : class_243.method_24954((class_2382)this.fadeOutTo.method_62675()).method_1021(0.5));
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.element == null) {
            return;
        }
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        this.element.setFade(1.0f - (1.0f - fade) * (1.0f - fade));
        if (this.remainingTicks == 0) {
            this.element.setVisible(false);
            this.element.setFade(0.0f);
        }
    }
}

