/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10811;
import net.minecraft.class_1087;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_765;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ItemFrameVisual
extends AbstractVisual
implements EntityVisual<class_1533>,
SimpleDynamicVisual {
    public static final RendererReloadCache<class_1087, Model> MODEL_RESOURCE_LOCATION = new RendererReloadCache<class_1087, Model>(model -> new BakedModelBuilder((class_1087)model).build());
    private final Matrix4f baseTransform = new Matrix4f();
    private final TransformedInstance frame;
    private final TransformedInstance item;
    private final class_1533 entity;
    private class_1087 lastFrameModel;
    private class_1799 lastItemStack;

    public ItemFrameVisual(VisualizationContext ctx, class_1533 entity, float partialTick) {
        super(ctx, entity.method_37908(), partialTick);
        this.entity = entity;
        this.lastItemStack = entity.method_6940().method_7972();
        this.lastFrameModel = this.getFrameModel();
        Model frameModel = MODEL_RESOURCE_LOCATION.get(this.lastFrameModel);
        this.frame = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, frameModel).createInstance();
        this.frame.setTransform((Matrix4fc)this.baseTransform);
        this.item = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, class_811.field_4319)).createInstance();
        this.animate(partialTick);
    }

    public static boolean shouldVisualize(class_1533 entity) {
        return !entity.method_6940().method_31574(class_1802.field_8204) && ItemModels.isSupported(entity.method_6940(), class_811.field_4319);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        int light = class_765.method_23687((int)this.getBlockLightLevel(this.entity.method_24515()), (int)this.getSkyLightLevel(this.entity.method_24515()));
        boolean invisible = this.entity.method_5767();
        class_2350 direction = this.entity.method_5735();
        class_2382 origin = this.visualizationContext.renderOrigin();
        float d = 0.46875f;
        float x = (float)(this.entity.method_23317() - (double)origin.method_10263() + (double)((float)direction.method_10148() * d));
        float y = (float)(this.entity.method_23318() - (double)origin.method_10264() + (double)((float)direction.method_10164() * d));
        float z = (float)(this.entity.method_23321() - (double)origin.method_10260() + (double)((float)direction.method_10165() * d));
        this.baseTransform.translation(x, y, z);
        this.baseTransform.rotateXYZ((float)Math.PI / 180 * this.entity.method_36455(), (float)Math.PI / 180 * (180.0f - this.entity.method_36454()), 0.0f);
        class_1799 stack = this.entity.method_6940();
        class_1087 frameLocation = this.getFrameModel();
        if (frameLocation != this.lastFrameModel) {
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MODEL_RESOURCE_LOCATION.get(frameLocation)).stealInstance(this.frame);
            this.lastFrameModel = frameLocation;
        }
        this.frame.setVisible(!invisible);
        this.frame.setTransform((Matrix4fc)this.baseTransform).translate(-0.5f, -0.5f, -0.5f).light(light).setChanged();
        if (!class_1799.method_7973((class_1799)this.lastItemStack, (class_1799)stack)) {
            this.lastItemStack = stack.method_7972();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, class_811.field_4319)).stealInstance(this.item);
        }
        this.item.setTransform((Matrix4fc)this.baseTransform);
        if (invisible) {
            this.item.translate(0.0f, 0.0f, 0.5f);
        } else {
            this.item.translate(0.0f, 0.0f, 0.4375f);
        }
        int i = this.entity.method_43273() ? this.entity.method_6934() % 4 * 2 : this.entity.method_6934();
        this.item.rotateZDegrees((float)i * 360.0f / 8.0f);
        this.item.scale(0.5f, 0.5f, 0.5f);
        this.item.light(this.getLightVal(light)).setChanged();
    }

    @Override
    public void update(float partialTick) {
    }

    @Override
    protected void _delete() {
        this.frame.delete();
        this.item.delete();
    }

    private int getLightVal(int regularLightVal) {
        return this.entity.method_5864() == class_1299.field_28401 ? 0xF000F0 : regularLightVal;
    }

    protected int getSkyLightLevel(class_2338 pos) {
        return this.level.method_8314(class_1944.field_9284, pos);
    }

    protected int getBlockLightLevelBase(class_2338 pos) {
        return this.entity.method_5809() ? 15 : this.level.method_8314(class_1944.field_9282, pos);
    }

    protected int getBlockLightLevel(class_2338 pos) {
        return this.entity.method_5864() == class_1299.field_28401 ? Math.max(5, this.getBlockLightLevelBase(pos)) : this.getBlockLightLevelBase(pos);
    }

    public class_1087 getFrameModel() {
        boolean bl = this.entity.method_5864() == class_1299.field_28401;
        class_2680 state = class_10811.method_68014((boolean)bl, (boolean)false);
        return class_310.method_1551().method_1541().method_3349(state);
    }
}

